package image_search;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DocumentSearcherTerasawa;
import jp.ac.hokudai.meme.core_smart_gs.searcher.FoundRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.IDocumentSearcher;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.QueryRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultRects;
import smart_gs.image_search.logical.SearchResult;

public abstract class ImageSearchAdapter {
	
	protected Query query;
	protected ArrayList<File> filesToSearch;
	protected ResultRects results;
	protected IDocumentSearcher engine;
	private int maxFound = 500;
	private int type;
	
	protected ImageSearchAdapter(){
		this.filesToSearch = new ArrayList<File>();
		this.type = IDocumentSearcher.TYPE_DTW_2;
		this.engine = DocumentSearcherTerasawa.getInstance(IDocumentSearcher.TYPE_DTW_2);
		this.engine.setMaxFound(this.maxFound);
	}
	public void setSearchType(int type){
		this.type = type;
		this.engine = DocumentSearcherTerasawa.getInstance(type);
		this.engine.setMaxFound(maxFound);
	}
	public int getMaxFound() {
		return maxFound;
	}
	public int getSearchType(){
		return this.type;
	}
	public void setMaxFound(int size){
		this.maxFound = size;
		this.engine.setMaxFound(maxFound);
	}
	protected ResultRects getResultRects(){
		return this.results;
	}
	protected void setSearchScope(ArrayList<File> filesToSearch){
		this.filesToSearch = filesToSearch;
	}
	public void setQuery(Query query){
		this.query = query;
	}
	
	public void setDSCFiles(List<File> filesToSearch){
		File[] files = new File[this.filesToSearch.size()];
		for(int i=0;i<this.filesToSearch.size();i++){
			files[i] = this.filesToSearch.get(i);
		}
		try {
			this.engine.addDscFile(files);
		} catch (IOException e) {
			e.printStackTrace();
			return;
		} catch (InvalidDataFormatException e) {
			e.printStackTrace();
		} 
	}
	
	public void execute() {
		this.engine.clearFileList();
		if(this.query.getDSCFile() == null){
			return;
		}
		this.filesToSearch.remove(this.query.getDSCFile());
		this.filesToSearch.add(0,this.query.getDSCFile());
		if(this.filesToSearch.size() == 0){
			JOptionPane.showMessageDialog(new JFrame(),"No DSC File");
			return ;
		}
		File[] files = new File[this.filesToSearch.size()];
		for(int i=0;i<this.filesToSearch.size();i++){
			files[i] = this.filesToSearch.get(i);
		}
		try {
			this.engine.addDscFile(files);
		} catch (IOException e) {
			e.printStackTrace();
			return;
		} catch (InvalidDataFormatException e) {
			e.printStackTrace();
		} 
		QueryRect queryRect = new QueryRect();
		queryRect.addQueryPRect(new PagedRect(0,this.query.getRectangle(),-1,-1));
		QueryRect qRect = this.engine.rectConfirm(queryRect);
		this.results = this.engine.search(queryRect);
	}
	
	public QueryRect rectConfirm(){
		QueryRect queryRect = new QueryRect();
		queryRect.addQueryPRect(new PagedRect(0,this.query.getRectangle(),-1,-1));
		QueryRect qRect = this.engine.rectConfirm(queryRect);
		return qRect;
	}
	
	
    
}
	

