/*
 * 쐬: 2004/05/22
 */
package jp.ac.hokudai.meme.core_smart_gs.ui;


import java.io.*;
import java.util.*;

import jp.ac.hokudai.meme.core_smart_gs.searcher.*;
import jp.ac.hokudai.meme.core_smart_gs.test.SearchOperator;
import jp.ac.hokudai.meme.core_smart_gs.ui.swt.ImageCanvas;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * @author hajime
 */
public class SearchAppli {

	public static void main(String[] args) {
		final Display display = new Display();
		final Shell shell = new SearchAppli().getUI(display);

		shell.open();
		
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
	}
	
	private Label searcherLabel_;
	private GC gc_;
	private ScrolledComposite comp_;
	private ImageCanvas iCanvas_;
	private Text pagePathText_;
	private Text pageNumText_;
	private int mUpX_;
	private int mUpY_;
	private int mDownX_;
	private int mDownY_;
	private boolean isSearchOK_;
	private Table matchTable_;
	private ResultRects searchResult_;
    private File[] fileList_ = new File[0];
    
	public Shell getUI(final Display display){
		
        final SearchOperator operator = new SearchOperator(IDocumentSearcher.TYPE_NORMAL);
		final DocHighLighter highLighter = new DocHighLighter();
		final Shell shell = new Shell(display);
		shell.setSize(675, 585);
		shell.setText("Core SmartGS Test.");
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 9;
		shell.setLayout(gridLayout);

		//Searcher Label
		searcherLabel_ = new Label(shell, SWT.NONE);
		searcherLabel_.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		searcherLabel_.setText("Searcher:");

		//Searcher Combo
        final Combo searcherCombo = new Combo(shell, SWT.READ_ONLY);
		final GridData g_searcher = new GridData(GridData.FILL_HORIZONTAL);
		g_searcher.horizontalSpan = 8;
		searcherCombo.setLayoutData(g_searcher);
		//Searcher炱ɒǉ
//        TODO
		searcherCombo.add("Normal Seacher");
		searcherCombo.add("Dummy Seacher");
		searcherCombo.select(0);

		//Documentx
		final Label docLabel = new Label(shell, SWT.NONE);
		docLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		docLabel.setText("Document:");
	
		//DocumenteLXg{bNX
		final Text docText = new Text(shell, SWT.BORDER|SWT.MULTI);
		final GridData g_doc = new GridData(GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL);
		g_doc.horizontalSpan = 6;
		docText.setLayoutData(g_doc);
	
		//docSelect{^
		final Button docSelectButton = new Button(shell, SWT.NONE);
		docSelectButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {				
				FileDialog dialog = new FileDialog(shell , SWT.OPEN | SWT.MULTI);
				String[] str1 = {"*.dsc"};
				dialog.setFilterExtensions(str1);
				dialog.open();
				String filePath = dialog.getFilterPath();
				String[] newFileNames = dialog.getFileNames();
                if(filePath == "" || newFileNames == null) return;
                for (int i = 0; i < newFileNames.length; i++) {
                    newFileNames[i] = filePath + "\\" + newFileNames[i];
                }
                
                File[] oldFileList = fileList_;
                ArrayList newList = new ArrayList();
                for (int i = 0; i < oldFileList.length; i++) {
                    newList.add(oldFileList[i]);
                }
                for (int i = 0; i < newFileNames.length; i++) {
                    newList.add(new File(newFileNames[i]));
                }
                fileList_ = (File[]) newList.toArray(new File[0]);
                
                String filePathStr = "";
                for (int i = 0; i < fileList_.length; i++) {
                    filePathStr += fileList_[i].toString() + "\n";
                }
				docText.setText(filePathStr);
			}
		});
		docSelectButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		docSelectButton.setText("select");
	
		//docLoad{^
		final Button docLoadButton = new Button(shell, SWT.NONE);
		docLoadButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(fileList_.length ==0 || fileList_ == null) return ;
				try {
                    fileList_ = operator.addDscFile(fileList_);
                    if (fileList_.length == 0) {
						return;
					}
                    String pageName = operator.getImagePath(0);
    				iCanvas_.loadImage(pageName);
    				gc_ = new GC(iCanvas_.getSourceImage());
    				pagePathText_.setText(pageName);
    				pageNumText_.setText("0");
                } catch (IOException e1) {
                    System.err.println("load dsc file error.");
                    e1.printStackTrace();
                } 
                
			}
		});
		docLoadButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		docLoadButton.setText("load");
		
		//Pagex
		final Label pageLabel = new Label(shell, SWT.NONE);
		pageLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		pageLabel.setText("Page:");
	
		//PageeLXg{bNX
		pageNumText_ = new Text(shell, SWT.BORDER);
		pageNumText_.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
	
		//PagePathx
		final Label pagePathLabel = new Label(shell, SWT.NONE);
		pagePathLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		pagePathLabel.setText("Path:");
	
		//PagePatheLXg{bNX
		pagePathText_ = new Text(shell, SWT.BORDER);
		final GridData g_pagePath = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		g_pagePath.horizontalSpan = 4;
		pagePathText_.setLayoutData(g_pagePath);
	
		//Search{^
		final Button searchButton = new Button(shell, SWT.NONE);
		searchButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
				if(isSearchOK_){
					operator.switchSeacher(IDocumentSearcher.TYPE_NORMAL);
                    //search start
                    PagedRect[] query = operator.confirmQueryRect();
					searchResult_ = null;
					if(isSearchOK_){
                        searchResult_ = operator.search();	
                    }
					if (searchResult_ == null|searchResult_.getSize() == 0) {
                        return;
                    }
                    iCanvas_.reload(pagePathText_.getText());
					gc_ = new GC(iCanvas_.getSourceImage());
                    highLighter.highLight(gc_, query, display, DocHighLighter.GREEN);
					highLighter.hitHighLight(gc_ , searchResult_, Integer.parseInt(pageNumText_.getText()) , display);
					iCanvas_.redraw();
                    gc_.dispose();
					
					matchTable_.removeAll();
					int counter = 0;
					for (int i = 0; i < searchResult_.getSize(); i++) {
                        PagedRect[] pagedRects = searchResult_.getPRects(i + 1);
                        double score = searchResult_.getScore(i + 1);
                        TableItem ti = new TableItem(matchTable_ , 0);
                        String[] taItem = { Integer.toString(counter) , Integer.toString(pagedRects[0].getPageIndex()), Integer.toString(pagedRects[0].getLineIndex()),Integer.toString(pagedRects[0].getSlitIndex()), Double.toString(score)};
                        ti.setText(taItem);
						counter++;
					}
				}
			}
		});
        
		final GridData gSearch = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gSearch.horizontalSpan = 2;
		searchButton.setLayoutData(gSearch);
		searchButton.setText("search");
	
		//PageNavigatorO[v
		final Group group = new Group(shell, SWT.NONE);
		final GridData gGroup = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gGroup.horizontalSpan = 9;
		group.setLayoutData(gGroup);
		final GridLayout gridLayout_1 = new GridLayout();
		gridLayout_1.numColumns = 6;
		group.setLayout(gridLayout_1);
		
		//<TOP{^
		final Button toTopbutton = new Button(group, SWT.NONE);
		toTopbutton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(operator.hasDscData()){
					int p_num = Integer.parseInt(pageNumText_.getText());
					if(p_num != 0){
						p_num = 0;				
						String pageName = operator.getImagePath(p_num);
						iCanvas_.loadImage(pageName);
						gc_ = new GC(iCanvas_.getSourceImage());
						pageNumText_.setText(Integer.toString(p_num));
						pagePathText_.setText(pageName);
						if(searchResult_ != null){
							highLighter.hitHighLight(gc_, searchResult_, Integer.parseInt(pageNumText_.getText()) , display);
						} 
					}					
				}
			}
		});
        
		toTopbutton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		toTopbutton.setText("<<TOP");

		//<Prev{^
		final Button toPrevButton = new Button(group, SWT.NONE);
		toPrevButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(operator.hasDscData()){
					int p_num = Integer.parseInt(pageNumText_.getText());
					if(p_num > 0){
						p_num --;				
						String pageName = operator.getImagePath(p_num);
						iCanvas_.loadImage(pageName);
						gc_ = new GC(iCanvas_.getSourceImage());
						pageNumText_.setText(Integer.toString(p_num));
						pagePathText_.setText(pageName); 
						if(searchResult_ != null){
                            highLighter.hitHighLight(gc_, searchResult_, Integer.parseInt(pageNumText_.getText()) , display);
						}
					}
				}
			}
		});
		toPrevButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		toPrevButton.setText("<Prev");

		//<Jump{^
		final Button prevHitButton = new Button(group, SWT.NONE);
		prevHitButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		prevHitButton.setText("<Jump");

		//Jump>{^
		final Button nextHitButton = new Button(group, SWT.NONE);
		nextHitButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		nextHitButton.setText("Jump>");

		//Next>{^
		final Button toNextButton = new Button(group, SWT.NONE);
		toNextButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(operator.hasDscData()){
					int p_num = Integer.parseInt(pageNumText_.getText());
					if(p_num+1 < operator.getPageCount()){
						p_num++;				
						String pageName = operator.getImagePath(p_num);
						iCanvas_.loadImage(pageName);
						gc_ = new GC(iCanvas_.getSourceImage());
						pageNumText_.setText(Integer.toString(p_num));
						pagePathText_.setText(pageName);
						if(searchResult_ != null){
                            highLighter.hitHighLight(gc_, searchResult_, Integer.parseInt(pageNumText_.getText()) , display);
						} 
					}					
				}
			}
		});
		toNextButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		toNextButton.setText("Next>");

		//End>{^
		final Button toEndButton = new Button(group, SWT.NONE);
		toEndButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(operator.hasDscData()){
					int p_num = Integer.parseInt(pageNumText_.getText());
					if(p_num + 1 != operator.getPageCount()){
						p_num = operator.getPageCount()-1;				
						String pageName = operator.getImagePath(p_num);
						iCanvas_.loadImage(pageName);
						gc_ = new GC(iCanvas_.getSourceImage());
						pageNumText_.setText(Integer.toString(p_num));
						pagePathText_.setText(pageName);
						if(searchResult_ != null){
                            highLighter.hitHighLight(gc_, searchResult_, Integer.parseInt(pageNumText_.getText()) , display);
						}
					}					
				}
			}
		});
		toEndButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		toEndButton.setText("END>>");

		//摜\LoX
		iCanvas_ = new ImageCanvas(shell, SWT.BORDER);

		iCanvas_.addMouseListener(new MouseAdapter() {
			public void mouseUp(MouseEvent e) {
				if(operator.hasDscData()){
					ImageCanvas ic1 = (ImageCanvas)e.widget;
					mUpX_ = e.x + ic1.getViewImagePoint().x;
					mUpY_ = e.y + ic1.getViewImagePoint().y;
					if( operator.setQuery(mDownX_, mDownY_, mUpX_, mUpY_, Integer.parseInt(pageNumText_.getText()))){
						isSearchOK_ = true;
						iCanvas_.reload(pagePathText_.getText());
						gc_ = new GC(iCanvas_.getSourceImage());
						highLighter.highLight(gc_ , operator.confirmQueryRect(), display , DocHighLighter.GREEN);
						ic1.redraw();
						gc_.dispose();
					}else{
						isSearchOK_ = false;
						iCanvas_.reload(pagePathText_.getText());
						gc_ = new GC(iCanvas_.getSourceImage()); 
					}
				}
			}
			
			public void mouseDown(MouseEvent e) {
                if(operator.hasDscData()){
                    ImageCanvas ic1 = (ImageCanvas) e.widget;
					mDownX_ = e.x + ic1.getViewImagePoint().x;
					mDownY_ = e.y + ic1.getViewImagePoint().y;
				}
			}
		});
		
		final GridData cGridData = new GridData(GridData.FILL_BOTH);
		cGridData.horizontalSpan = 8;
		iCanvas_.setLayoutData(cGridData);

		//qbg\e[u
		matchTable_ = new Table(shell, SWT.BORDER);
		final GridData tabGridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.FILL_VERTICAL);
		matchTable_.setLayoutData(tabGridData);
		matchTable_.setLinesVisible(true);
		matchTable_.setHeaderVisible(true);
        

		final TableColumn columnNo = new TableColumn(matchTable_, SWT.NONE);
		columnNo.setWidth(30);
		columnNo.setText("No");

		final TableColumn columnPage = new TableColumn(matchTable_, SWT.NONE);
		columnPage.setWidth(40);
		columnPage.setText("Page");

		final TableColumn columnLine = new TableColumn(matchTable_, SWT.NONE);
		columnLine.setWidth(40);
		columnLine.setText("Line");
        
		final TableColumn columnSlit = new TableColumn(matchTable_, SWT.NONE);
		columnSlit.setWidth(40);
		columnSlit.setText("Slit");
		
		final TableColumn columnChar = new TableColumn(matchTable_, SWT.NONE);
		columnChar.setWidth(80);
		columnChar.setText("Score");

				
		return shell;
	}
	
}
