package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.GSResource;

/**
 * 
 * @author kazuaki kobayashi
 * 
 *
 */
public class ResourcePointer {
	
	protected double elementRank = 0.15;
	//regiontagelement
	protected RWElement element;
	//2007/10/23 kazuhiro kobayashi
//	protected ExplanatoryNote expNote;
	protected String name = "";
	
	protected List<ResourcePointer> targets;
	protected List<ResourcePointer> sources;
	protected List<Connection> connections;
	//20080521shimizu wrote;
	public int position = 0;
	
	
		
	protected ResourcePointer(RWElement element){
		this.element = element;
		this.connections = new ArrayList<Connection>();
		this.targets = new ArrayList<ResourcePointer>();
		this.sources = new ArrayList<ResourcePointer>();
	}
	public List<ResourcePointer> getForwarLinkElements(){
		return this.targets;
	}
	public List<ResourcePointer> getBackLinkElements(){
		return this.sources;
	}
	public List<RWElement> getDirectLinkElements(){
		List<RWElement> elements = new ArrayList<RWElement>();
		for(int i=0;i<this.targets.size();i++){
			elements.add(this.targets.get(i).getElement());
		}
		for(int i=0;i<this.sources.size();i++){
			elements.add(this.sources.get(i).getElement());
		}
		return elements;
	}

	void addConnection(Connection connection){
		this.connections.add(connection);
	}

	public void addTarget(ResourcePointer target){
		this.targets.add(target);
	}
	
	public void addSource(ResourcePointer source){
		this.sources.add(source);
	}
	
	public RWElement getElement(){
		return this.element;
	}
	
	public double getElementRank(){
		return this.elementRank;
	}
	public boolean hasLink() {
		if(this.connections.size() <= 0){
			return false;
		}
		return true;
	}
	
	public List<ResourcePointer> getDependentElements(){
		List<ResourcePointer> results = new ArrayList<ResourcePointer>();
		for(int i=0;i<this.connections.size();i++){
			ResourcePointer pointer = this.connections.get(i).getDependentResource(this);
			if(pointer != null){
				results.add(pointer);
			}
		}
		return results;
	}

	public int getNumberOfDependentElements(){
		return this.getDependentElements().size();
	}
	
	public List<ResourcePointer> getBackwardDependentElements(){
		List<ResourcePointer> results = new ArrayList<ResourcePointer>();
		for(int i=0;i<this.connections.size();i++){
			ResourcePointer pointer = this.connections.get(i).getBackwardDependentResource(this);
			if(pointer != null){
				results.add(pointer);
			}
		}
		return results;
	}
	public void setElementRank(double rank){
		this.elementRank = rank;
	}
	public String getSource() throws NotMarkupException {
		throw new NotMarkupException();
	}
	
	//2007/10/23 kazuhiro kobayashi
	public void setName(String name){
		this.name = name;
		
	}
	public String getName(){
		return this.name;
	}
	//2007/11/1 kazuhiro kobayashi
	public boolean hasConnection(){
		//2007/11/19 kazuhiro kobayashi
		return this.connections.size() > 0;
	}
	public void removeConnection(Connection connection){
		this.connections.remove(connection);
	}
}
