/*
 * 쐬: 2006/06/04
 *
 */
package smart_gs.connection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import smart_gs.logical.Preference;
import smart_gs.reasoning_web.ExplanatoryNoteDialog;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.toolbar.EditorToolBarPlan;


/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")
public class ExplanatoryPanel extends JPanel {

    private ExplanatoryNoteDialog parent;
	private GSExplanatoryNote explanatoryNote;
	private JPanel toolbarPanel;
	
	private GSEditorTextPane textPane;
	//2007/10/23 kazuhiro kobayashi
	private String title;
	private JTextField nameField;
	
	
	
	/**
	 * @param note
	 */
	public ExplanatoryPanel(ExplanatoryNoteDialog parent,GSExplanatoryNote note) {
		this.parent = parent;
		this.explanatoryNote = note;
		//2007/10/23 kazuhiro kobayashi
		this.title = this.explanatoryNote.getName();
		//
		this.setLayout(new BorderLayout());
		
		JPanel notePanel = new JPanel();
		notePanel.setLayout(new BorderLayout());
		
		JPanel textPanel = new JPanel();
		textPanel.setBorder(new TitledBorder("annotation"));
		textPanel.setLayout(new BorderLayout());
		/*
		SmlController controller = new SmlController();
		try {
			controller.setSource(this.explanatoryNote.getSource());
		} catch (SAXException e) {
			try {
				controller.setSource("<xml></xml>");
			} catch (SAXException e1) {
				e1.printStackTrace();
			}
		}
		*/
		String source = null;
		String xml = explanatoryNote.getSource();;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		this.textPane = new GSEditorTextPane(this.explanatoryNote,source,GSEditorTextPane.BASIC);
		textPane.setMarkup(false);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));
		//2007/11/20 kazuhiro kobayashi
		JScrollPane scrollPane = new JScrollPane(this.textPane);
		textPanel.add(scrollPane,BorderLayout.CENTER);
		//
		notePanel.add(textPanel,BorderLayout.CENTER);
		notePanel.setBorder(new LineBorder(Color.BLACK));
		JPanel infoPanel = this.createInfoPanel();
		notePanel.add(infoPanel,BorderLayout.NORTH);
		
		this.toolbarPanel = new JPanel();
		this.toolbarPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		EditorToolBarPlan toolBarPlan = new EditorToolBarPlan();
		toolBarPlan.setMarkup(false);
		this.toolbarPanel.add(new GSEditorToolBar(textPane,toolBarPlan));
		
		
		JPanel buttonPanel = new JPanel();
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new OKAction());
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new CancelAction());
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		
		this.add(this.toolbarPanel,BorderLayout.NORTH);
		this.add(notePanel,BorderLayout.CENTER);
		this.add(buttonPanel,BorderLayout.SOUTH);
		this.setSize(400,400);
	}

	private JPanel createInfoPanel(){
		JPanel panel = new JPanel();
		panel.setLayout(new GridLayout(2,1));
		
		JPanel infoPanel = new JPanel();
		infoPanel.setLayout(new BorderLayout());
		
		JPanel datePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		Calendar calendar = Calendar.getInstance();
		String date = calendar.get(Calendar.YEAR)+"/"+calendar.get(Calendar.MONTH)+"/"+calendar.get(Calendar.DATE);
		JLabel label = new JLabel("date: "+date);
		datePanel.add(label);
		
		
		JPanel titlePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		nameField = new JTextField(15);
		nameField.setBorder(new TitledBorder("title"));
		//2007/10/23 kazuhiro kobayashi
		nameField.setText(this.title);
		titlePanel.add(nameField);
		
		JTextField userField = new JTextField(15);
		String defName = Preference.getInstance().getUserName();
		userField.setText(defName);
		userField.setBorder(new TitledBorder("user name"));
		titlePanel.add(userField);
		
	
		infoPanel.add(datePanel,BorderLayout.NORTH);
		infoPanel.add(titlePanel,BorderLayout.CENTER);
		
		JPanel typePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		typePanel.setBorder(new TitledBorder("type"));
		ButtonGroup group = new ButtonGroup();
		JRadioButton def = new JRadioButton("default");
		def.setSelected(true);
		JRadioButton transcription = new JRadioButton("transcription");
		JRadioButton translation = new JRadioButton("translation");
		group.add(def);
		group.add(transcription);
		group.add(translation);
		typePanel.add(def);
		typePanel.add(transcription);
		typePanel.add(translation);
		
		panel.add(infoPanel);
		panel.add(typePanel);

		return panel;
	}
	
	public GSEditorTextPane getTextPane() {
		return textPane;
	}
	public JPanel getTextPanel(){
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(this.textPane,BorderLayout.CENTER);
		return panel;
	}
	
	private class OKAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			String source = textPane.getSource("body");
			//2007/10/23 kazuhiro kobayashi
			title = nameField.getText();
			explanatoryNote.setName(title);
			explanatoryNote.setSource("<xml><html>" + source + "</html></xml>");
			parent.dispose();
			
		}
	}
	
	private class CancelAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			parent.setIsCanceled(true);
			parent.dispose();
		}
	}

}
