package smart_gs.drawing_tool;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class ImageLabel extends JLabel implements MouseListener,
		MouseMotionListener {

	private final int DEFAULT_WIDTH = 1200;
	private final int ZOOM_VALUE = 200;
	//20080617 shimizu wrote
	//private final int ZOOM_VALUE = 400;
	//

	private int count = 0;

	private static State state;
	private static boolean isLineShown = false;

	private static boolean isRectangleShown = true;

	private SpreadCanvas canvas;
	private Spread spread;
	private ImageIcon imageIcon;

	private int currentWidth;
	private int currentHeight;

	private int imageWidth;
	private int imageHeight;
	private Image image;

	private List<View> tempViews;
	// private static List<Region> tempRegion ;

	// 2007/11/19 kazuhiro kobayashi
	private final Rectangle rect = new Rectangle();
	private Point2D start = null;
	private Point2D end = null;
	private int zoom = 0;

	static {
		ImageLabel.state = DefaultState.getInstance();
		isLineShown = false;
	}

	public ImageLabel(SpreadCanvas canvas, ImageIcon imageIcon) {
		super(imageIcon);
		this.canvas = canvas;
		this.spread = this.canvas.getSpread();
		this.imageIcon = imageIcon;
		this.imageWidth = this.imageIcon.getIconWidth();
		this.imageHeight = this.imageIcon.getIconHeight();
		this.image = this.imageIcon.getImage();
		this.tempViews = new ArrayList<View>();
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		//
//		this.addMouseWheelListener(this);
		//
		this.showImage();
		this.setLayout(new FlowLayout(FlowLayout.LEFT));
	}

	private void showImage() {
		double ratio = (double) imageWidth / (double) imageHeight;
		int w = DEFAULT_WIDTH + count * ZOOM_VALUE;
		this.currentWidth = w;
		this.currentHeight = (int) (w / ratio);
		BufferedImage bufImage = new BufferedImage(this.currentWidth,
				this.currentHeight, BufferedImage.TYPE_INT_RGB);
		Graphics offg = bufImage.getGraphics();
		offg
				.drawImage(image, 0, 0, this.currentWidth, this.currentHeight,
						this);
		this.setSize(this.currentWidth, this.currentHeight);
		this.setIcon(new ImageIcon(bufImage));
	}

	public Point getCornerPoint() {
		return this.getLocation();
	}

	public void zoomIn() {
		// 2007/11/19 kazuhiro kobayashi
		//2008/06/18 ܂ł摜gł悤ϐύX@by shimizu
		if (this.count < 21) {
//		if (this.count < 5) {
			this.count++;
			this.showImage();
		}
	}

	public void zoomOut() {
		// 2007/11/19 kazuhiro kobayashi
		if (this.count > -5) {
			this.count--;
			this.showImage();
		}
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);

		int width = spread.getWidth();
		int w = DEFAULT_WIDTH + count * ZOOM_VALUE;
		double ratio = (double) ((double) w / (double) width);
		List<Region> regions = spread.getRegions();

		int canvasWidth = this.canvas.getWidth();
		int canvasHeight = this.canvas.getHeight();
		int iconHeight = this.getIcon().getIconHeight();
		int iconWidth = this.getIcon().getIconWidth();

		int scrollHeight = this.canvas.getHorizontalScrollBar().getHeight();
		int scrollWidth = this.canvas.getVerticalScrollBar().getWidth();
		double gapX = 0;
		double gapY = 0;

		if (iconWidth < canvasWidth) {
			gapX = (canvasWidth - scrollWidth - iconWidth) / 2.0;
		}
		if (iconHeight < canvasHeight) {
			gapY = (canvasHeight - scrollHeight - iconHeight) / 2.0;
		}
		for (int i = 0; i < regions.size(); i++) {
			View view = regions.get(i).getView()
					.enlargedView(ratio, gapX, gapY);
			if (GS_RWRepository.getInstance().hasLink(regions.get(i))) {
				view.drawLinkedShape((Graphics2D) g);
			} else {
				view.draw((Graphics2D) g);
			}
		}
		for (int i = 0; i < this.tempViews.size(); i++) {
			View view = this.tempViews.get(i).enlargedView(ratio, gapX, gapY);
			view.draw((Graphics2D) g);
		}
		if (isLineShown) {

			List<LineSegment> lines = spread.getLines();
			for (int i = 0; i < lines.size(); i++) {
				View view = lines.get(i).getView().enlargedView(ratio, gapX,
						gapY);
				view.draw((Graphics2D) g);
			}
		}
		state.paint(g, canvas);
	}

	public double getGapWidth() {
		int canvasWidth = this.canvas.getWidth();
		int iconWidth = this.getIcon().getIconWidth();
		int scrollWidth = this.canvas.getVerticalScrollBar().getWidth();
		double gapX = 0;
		if (iconWidth < canvasWidth) {
			gapX = (canvasWidth - scrollWidth - iconWidth) / 2.0;
		}
		return gapX;
	}

	public double getGapHeight() {
		int canvasHeight = this.canvas.getHeight();
		int iconHeight = this.getIcon().getIconHeight();
		int scrollHeight = this.canvas.getHorizontalScrollBar().getHeight();
		double gapY = 0;
		if (iconHeight < canvasHeight) {
			gapY = (canvasHeight - scrollHeight - iconHeight) / 2.0;
		}
		return gapY;
	}

	public double getRatio() {
		int width = spread.getWidth();
		int w = DEFAULT_WIDTH + count * ZOOM_VALUE;
		double ratio = ((double) ((double) w / (double) width));
		return ratio;
	}

	public void addRegion(Region region) {
		View view = region.getView();
		region.setView(view);
		spread.addRegion(region);
	}

	/**
	 * 
	 * @param point
	 *            ݂̕\TCYɂ摜pointIWiTCYpointɕϊ
	 * @return
	 */
	public Point getAdjustedPoint(Point point) {
		double x = point.x;
		double y = point.y;
		int canvasWidth = this.canvas.getWidth();
		int canvasHeight = this.canvas.getHeight();
		int iconHeight = this.getIcon().getIconHeight();
		int iconWidth = this.getIcon().getIconWidth();

		double gapX = 0;
		double gapY = 0;
		int scrollHeight = this.canvas.getHorizontalScrollBar().getHeight();
		int scrollWidth = this.canvas.getVerticalScrollBar().getWidth();
		if (iconWidth < canvasWidth) {
			gapX = (double) (canvasWidth - scrollWidth - iconWidth) / 2.0;

		}
		if (iconHeight < canvasHeight) {
			gapY = (canvasHeight - scrollHeight - iconHeight) / 2.0;

		}

		x -= gapX;
		y -= gapY;

		int width = this.spread.getWidth();
		int w = iconWidth;
		double ratio = (double) ((double) w / (double) width);
		Point p = new Point((int) (x / ratio), (int) (y / ratio));
		return p;
	}

	private GSMouseEvent getAdjustedMouseEvent(MouseEvent e) {
		Point p = this.getAdjustedPoint(e.getPoint());
		return new GSMouseEvent(e, p);
	}

	public void mouseDragged(MouseEvent e) {
		// 2007/11/20 kazuhiro kobayashi
		this.end = e.getPoint();
		if (DefaultState.getInstance().getMode() == DefaultDrawingMode
				.getInstance()) {
			this.setCursor(new Cursor(Cursor.HAND_CURSOR));
			Rectangle r = this.getVisibleRect();
			this.rect.setRect(r.x + (-this.end.getX() + this.start.getX()), r.y
					- this.end.getY() + this.start.getY(), r.getWidth(), r
					.getHeight());
			this.scrollRectToVisible(this.rect);
		}
		//
		GSMouseEvent ge = this.getAdjustedMouseEvent(e);
		state.mouseDragged(ge, canvas);
		this.repaint();
	}

	public void mouseMoved(MouseEvent e) {
		GSMouseEvent ge = this.getAdjustedMouseEvent(e);
		state.mouseMoved(ge, canvas);
		this.repaint();
	}

	public void mouseClicked(MouseEvent e) {
		GSMouseEvent ge = this.getAdjustedMouseEvent(e);
		state.mouseClicked(ge, canvas);
		this.repaint();
	}

	public void mouseEntered(MouseEvent e) {
		GSMouseEvent ge = this.getAdjustedMouseEvent(e);
		state.mouseEntered(ge, canvas);
		this.repaint();
	}

	public void mouseExited(MouseEvent e) {
		GSMouseEvent ge = this.getAdjustedMouseEvent(e);
		state.mouseExited(ge, canvas);
		this.repaint();
	}

	public void mousePressed(MouseEvent e) {
		// 2007/11/19 kazuhiro kobayashi
		this.start = e.getPoint();
		//
		this.tempViews.clear();
		GSMouseEvent ge = this.getAdjustedMouseEvent(e);
		state.mousePressed(ge, canvas);
		this.repaint();
	}

	public void mouseReleased(MouseEvent e) {
		// 2007/11/19 kazuhiro kobayashi
			this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
			this.start = null;
			this.end = null;
		//
		GSMouseEvent ge = this.getAdjustedMouseEvent(e);
		state.mouseReleased(ge, canvas);
		this.repaint();
	}

	public static void setState(State state) {
		ImageLabel.state = state;
	}

	public static void setLineVisible(boolean isLineShown) {
		ImageLabel.isLineShown = isLineShown;
		WorkspaceWindow.getInstance().repaint();
	}

	public static boolean isLineShown() {
		return isLineShown;
	}

	/*
	 * 2007/9/11
	 */
	public static void setRectangleVisible(Boolean isRectangleShown) {
		ImageLabel.isRectangleShown = isRectangleShown;
		WorkspaceWindow.getInstance().repaint();
	}

	public static boolean isRectangleShown() {
		return isRectangleShown;
	}

	/**
	 * 
	 * @param point
	 *            original摜TCYɂʒuw肷
	 */
	public void setCenterLocation(Point point) {
		double ratio = this.getRatio();
		int x = (int) (point.x * ratio);
		int y = (int) (point.y * ratio);
		this.setLocation(-x + 100, -y + 100);
	}

	public void addTempView(View view) {
		this.tempViews.add(view);
	}

	/**
	 * ݕ\ĂXvbh擾 iShowRegionɎg߁j
	 * 
	 * @return
	 */
	public Spread getSpread() {
		return this.spread;
	}

	// 2007/11/19 kazuhiro kobayashi
//	public void mouseWheelMoved(MouseWheelEvent e) {
//		if (e.getWheelRotation() < 0) {
//			if (this.count > -5) {
//				this.count--;
//				this.showImage();
//			}
//		} else if (e.getWheelRotation() > 0) {
//			if (this.count < 6) {
//				this.count++;
//				this.showImage();
//			}
//		}

//	}

}
