package smart_gs.image_search.normal.swingui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

import smart_gs.reasoning_web.RootFolder;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;

public class CreateFileInfo {
	
	public static File create(){
		DeskTopFolder root = RootFolder.getInstance();
		File file = null;
		try {
			file = new File(new URI("file:/root/"));
			file.mkdir();
			create(file,root);
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return file;
	}
	
	private static void create(File parent,DesktopElement element){
		
		try {

			if(element instanceof DeskTopFolder){
				List<DesktopElement> children = ((DeskTopFolder)element).getAllElements();
				for(int i=0;i<children.size();i++){
					File file = new File(new URI(parent.toURI()+element.getName()));
					create(file,children.get(i));
				}
			}

		} catch (URISyntaxException e) {
			e.printStackTrace();
		}
		
	}
}
