package smart_gs.image_search.research.swingui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.research.SearchResultSet;

@SuppressWarnings("serial")
public class RESearchResultViewer extends JFrame{
	
	private RESearchResultPanel resultPanel;
	JScrollPane scrollPane;
	
	public RESearchResultViewer(List<GSQuery> queries,List<SearchResultSet> results) {
		super("Search Result");
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		JPanel queryPanel = new REQueryPanel(queries);
		this.scrollPane = new JScrollPane();
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.resultPanel = new RESearchResultPanel(results);
		this.resultPanel.showResult(0);
		scrollPane.setViewportView(this.resultPanel);
		
		JPanel buttonPanel = new JPanel();
		JButton back = new JButton("back");
		JButton next = new JButton("next");
		next.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				resultPanel.next();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});
		back.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultPanel.back();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});
		buttonPanel.add(back);
		buttonPanel.add(next);
		
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(queryPanel,BorderLayout.NORTH);
		this.getContentPane().add(this.scrollPane,BorderLayout.CENTER);
		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		this.setSize(600,700);
	}
}
