package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.FreeLineMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.Region;
import smart_gs.swingui.AbstractGSWindow;

/**
 * 2007/11/1 kazuhiro kobayashi
 * @author Administrator
 *
 */
public class ToolMenu extends JMenu implements ActionListener {

	private JMenuItem select;
	private JMenuItem eraser;
	private JMenuItem rectangle;
	private JMenuItem marker;
	private JMenuItem lasso;
	private JMenuItem zoomIn;
	private JMenuItem zoomOut;
	private JMenuItem showRegion;
	private AbstractGSWindow parent;

	public ToolMenu(String title, AbstractGSWindow parent) {
		super(title);
		this.parent = parent;

		this.select = new JMenuItem("select", new ImageIcon(
				GSConstants.ICON_PATH + "select.gif"));
		this.select.addActionListener(this);
		this.add(this.select);

		this.eraser = new JMenuItem("delete", new ImageIcon(
				GSConstants.ICON_PATH + "delete.gif"));
		this.eraser.addActionListener(this);
		eraser.setAccelerator(KeyStroke.getKeyStroke("ctrl D"));
		this.add(this.eraser);

		this.addSeparator();

		this.rectangle = new JMenuItem("Rectangle");
		this.rectangle.addActionListener(this);
		this.add(this.rectangle);

		this.marker = new JMenuItem("Marker");
		this.marker.addActionListener(this);
		this.add(this.marker);

		this.lasso = new JMenuItem("Lasso");
		this.lasso.addActionListener(this);
		this.add(this.lasso);

		this.addSeparator();

		this.zoomIn = new JMenuItem("zoom in", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_in.gif"));
		this.zoomIn.addActionListener(this);
		this.add(this.zoomIn);

		this.zoomOut = new JMenuItem("zoom out", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_out.gif"));
		this.zoomOut.addActionListener(this);
		this.add(this.zoomOut);

		this.addSeparator();

		this.showRegion = new JMenuItem("showRegion");
		this.showRegion.addActionListener(this);
		this.add(this.showRegion);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.select)) {
			DefaultState.getInstance()
					.setMode(DefaultDrawingMode.getInstance());
		} else if (e.getSource().equals(this.rectangle)) {
			DefaultState.getInstance().setMode(RectangleMode.getInstance());
		} else if (e.getSource().equals(this.marker)) {
			DefaultState.getInstance().setMode(MarkerMode.getInstance());
		} else if (e.getSource().equals(this.lasso)) {
			DefaultState.getInstance().setMode(FreeLineMode.getInstance());
		} else if (e.getSource().equals(this.zoomIn)) {
			parent.getSpreadCanvas().zoomIn();
		} else if (e.getSource().equals(this.zoomOut)) {
			parent.getSpreadCanvas().zoomOut();
		} else if (e.getSource().equals(this.eraser)) {
			Region region = UniSelectedState.getInstance().getSelectedRegion();
			new DeleteRegionAction(region).execute();
			parent.repaint();
		} else if (e.getSource().equals(this.showRegion)) {
			parent.getSpreadCanvas().getSpread().changeShowRegion();
			parent.repaint();
		}
	}
}
