package smart_gs.reasoning_web;

import javax.swing.JPanel;
import java.awt.Frame;
import java.awt.BorderLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JButton;

import smart_gs.util.HrefChecker;

public class ExternalLinkDialog extends JDialog {
	protected static final  Pattern pattern = Pattern.compile("(http://|https://){1}[\\w\\.\\-/:\\#\\?\\=\\&\\;\\%\\~\\+]+");
	
	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JTextField urlField = null;

	private JButton okButton = null;

	private JButton cancelButton = null;

	private String urlStr = null;
	
	private boolean cancel = false;

	private String url = null;
	
	private JDialog myJDialog;

	/**
	 * @param owner
	 */
	public ExternalLinkDialog(Frame owner) {
		this(owner,null);
	}

	public ExternalLinkDialog(Frame owner,String urlStr) {
		super(owner,true);
		this.urlStr = urlStr;
		initialize();
		myJDialog = this;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(398, 115);
		this.setContentPane(getJContentPane());
		this.setTitle("External link");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getUrlField(), null);
			jContentPane.add(getOkButton(), null);
			jContentPane.add(getCancelButton(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes urlField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getUrlField() {
		if (urlField == null) {
			urlField = new JTextField();
			urlField.setBounds(new Rectangle(25, 16, 341, 26));
			if(urlStr == null){
				urlField.setText("http://");
			}else{
				urlField.setText(urlStr);
			}
		}
		return urlField;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton();
			okButton.setBounds(new Rectangle(100, 50, 90, 25));
			okButton.setText("OK");
			okButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					String urlCheck = urlField.getText();
					boolean warning =  false;
					try {
						Matcher matcher = pattern.matcher(urlCheck);
						if(matcher.find()){
							new URL(urlCheck);
							int checkid = HrefChecker.check(urlCheck);
							if(checkid != -1){
								warning  = true;
							}
						}else{
							warning = true;
						}
					} catch (MalformedURLException e1) {
						warning = true;
					}
					if(warning){
			        	JOptionPane.showMessageDialog(
								new JFrame() , "Please input correct URL." , "warning" ,
								JOptionPane.WARNING_MESSAGE
							);
			        	return;
					}
					url = urlCheck;
					myJDialog.setVisible(false);
				}
			});
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton();
			cancelButton.setBounds(new Rectangle(205, 50, 90, 25));
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					cancel = true;
					myJDialog.setVisible(false);
				}
			});
		}
		return cancelButton;
	}
	protected void processWindowEvent(WindowEvent e) {
	    if (e.getID() == WindowEvent.WINDOW_CLOSING ) {
	    	cancel = true;
	        this.setVisible(false);
	    }
	}
	
	public String getUrl(){
		return url;
	}

	public boolean isCancel() {
		return cancel;
	}
	
}  //  @jve:decl-index=0:visual-constraint="10,10"
