package smart_gs.reasoning_web.logical;

import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.reasoning_web.swingui.view.ConnectionView;
import smart_gs.reasoning_web.swingui.view.View;

public class GSConnection extends Connection implements GS_RWElement {

	protected View view;

	protected GSConnection(ResourcePointer source, ResourcePointer target,
			ExplanatoryNote note, int dependency) {
		super(source, target, note, dependency);
		this.view = new ConnectionView(this);

		// 2007/11/12 kazuhiro kobayashi
//		ExpNoteManager.getInstance().addNote((GSExplanatoryNote) this.expNote);
	}

	public View getView() {
		return this.view;
	}

	public JPanel createElementViewPanel() throws NoWayToShowException {
		try {
			return ((GSExplanatoryNote) this.expNote).createElementViewPanel();
		} catch (NoWayToShowException e) {
			throw e;
		}
	}

	@Override
	public GSResourcePointer getOppositePointer(ResourcePointer pointer) {
		return (GSResourcePointer) super.getOppositePointer(pointer);
	}

	@Override
	public GSResourcePointer getSourcePointer() {
		return (GSResourcePointer) super.getSourcePointer();
	}

	@Override
	public GSResourcePointer getTargetPointer() {
		return (GSResourcePointer) super.getTargetPointer();
	}

	public void show() {
		((GSExplanatoryNote) this.expNote).show();
	}

	public String getURI() {
		return "SMART://connection/" + this.name;
	}

	public Element createXMLElement(Document document) {
		Element element = document.createElement("connection");
		element.setAttribute("name", this.name);
		Element sourceElem = ((GSResourcePointer) this.source)
				.createXMLElement(document);
		sourceElem.setAttribute("type", "source");
		element.appendChild(sourceElem);
		Element targetElem = ((GSResourcePointer) this.target)
				.createXMLElement(document);
		targetElem.setAttribute("type", "target");
		element.appendChild(targetElem);
		element.appendChild(((GSExplanatoryNote) this.expNote)
				.createXMLElement(document));
		return element;
	}

	public static GSConnection restore(Element element) {
		String name = element.getAttribute("name");
		GSResourcePointer source = null;
		GSResourcePointer target = null;
		NodeList list = element.getElementsByTagName("pointer");
		Element elem1 = (Element) list.item(0);
		String type = elem1.getAttribute("type");
		if (type.equals("source")) {
			source = GSResourcePointer.restore(elem1);
		} else {
			target = GSResourcePointer.restore(elem1);
		}
		Element elem2 = (Element) list.item(1);
		String type2 = elem2.getAttribute("type");
		if (type2.equals("source")) {
			source = GSResourcePointer.restore(elem2);
		} else {
			target = GSResourcePointer.restore(elem2);
		}

		Element noteElement = (Element) element.getElementsByTagName(
				"explanatory").item(0);

		GSExplanatoryNote note = GSExplanatoryNote.restore(noteElement);
		/*
		 * dependencyrestore
		 */
		GSConnection connection = new GSConnection(source, target, note,
				Connection.TARGET_TO_SOURCE);
		connection.setName(name);
		return connection;
	}
}
