package smart_gs.reasoning_web.logical;

import javax.swing.JPanel;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.ConvertGS;
import smart_gs.logical.GSResource;
import smart_gs.logical.TextSegment;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.ExplanatoryNoteDialog;
import smart_gs.smleditor.swingui.GSEditorTextPane;

public class GSExplanatoryNote extends ExplanatoryNote implements GS_RWElement{
	
	public GSExplanatoryNote(String source) {
		super(source);
//		System.out.println("expNote"+this.id);
	}

	
	public JPanel createElementViewPanel() throws NoWayToShowException {
		ExplanatoryNoteDialog dialog = new ExplanatoryNoteDialog(this);
		dialog.setEnabled(false);
		return dialog.getLocalViewPanel();
	}
	//2007/11/2 kazuhiro kobayashi 
	public ExplanatoryNoteDialog createDialog() throws NoWayToShowException{
		return new ExplanatoryNoteDialog(this);
	}
	public JPanel getLocalViewPanel(ExplanatoryNoteDialog dialog){
		return dialog.getLocalViewPanel();
	}
	
	public GSEditorTextPane getTextPane(ExplanatoryNoteDialog dialog){
		dialog.setEnabled(false);
		return dialog.getTextPane();
	}
	//
	
	public String getURI() {
		return GSConstants.URI_HEADER+"explanatory/"+this.name;
	}
	public GSResource getTextSegmentByURI(String uri) {
		for(int i=0;i<this.segments.size();i++){
			if(this.segments.get(i).getURI().equals(uri)){
				return this.segments.get(i);
			}
		}
		return null;
	}
	public static GSExplanatoryNote restore(Element noteElement) {
		int id = new Integer(noteElement.getAttribute("id"));
		GSExplanatoryNote note = null;
		note = ExpNoteManager.getInstance().getExplanatoryNote(id);
		if(note == null){
			String source = noteElement.getAttribute("source");
			if(!source.startsWith("<xml><html>")){
				try{
					ConvertGS convertGS = new ConvertGS(source);
					source = convertGS.parser();
					if(source.equals("")){
						source = "<xml><html></html></xml>";
					}else{
						source = "<xml><html>" + source + "</html></xml>";
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
            String name = noteElement.getAttribute("name");
			note = new GSExplanatoryNote(source);
			note.setName(name);
			NodeList list = noteElement.getElementsByTagName("segment");
			for(int i=0;i<list.getLength();i++){
				TextSegment segment = TextSegment.restore((Element)list.item(i));
				note.addTextSegment(segment);
				segment.setSmartDocument(note);
			}
		}
	    return note;
	}
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
}
