package smart_gs.text_search;

import java.io.StringReader;
import smart_gs.logical.Spread;
import java.util.List;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.Iterator;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.logical.SmartDocument;
import smart_gs.text_search.logical.TextSearchConstants;
import smart_gs.text_search.swingui.TextToShow;
import smart_gs.util.StringUtils;
import smart_gs.logical.*;
import smart_gs.logical.PresentationTree;

public class TextSearchEngine {
	private static TextSearchEngine singleton = new TextSearchEngine();
	private String queryText;
	private List<Spread> spreadsToSearch;
	private int documentType;
	private List<SearchResult> results;
	private SmartDocument document;
	private boolean isCaseSensitive;
	private char LEFTPAGE = TextSearchConstants.LEFTPAGE;

	public TextSearchEngine() {
	}

	public static TextSearchEngine getInstance() {
		return singleton;
	}

	public void setQueryText(String queryText) {
		this.queryText = queryText;
	}

	public void setCaseSensitive(boolean caseSensitive) {
		this.isCaseSensitive = caseSensitive;
	}

	public void setSearchScope(List<Spread> spreadsToSearch) {
		this.spreadsToSearch = spreadsToSearch;
	}

	public void setDocumentType(int documentType) {
		this.documentType = documentType;
	}

	public void execute() {
		this.results = new ArrayList<SearchResult>();
		switch (documentType) {
		case TextSearchConstants.TEXT:
			ArrayList<Presentation> arrList1 = (ArrayList<Presentation>) PresentationTree
					.getInstance().getPresentations();
			Iterator<Presentation> it1 = arrList1.iterator();
			while (it1.hasNext()) {
				addResults(queryText, (SmartDocument) it1.next(),
						isCaseSensitive);
			}
			break;
		case TextSearchConstants.TRANSCRIPTION:
			for (int i = 0; i < spreadsToSearch.size(); i++) {
				document = spreadsToSearch.get(i).getTranscription();
				addResults(queryText, document, isCaseSensitive);
			}
			break;
		case TextSearchConstants.TRANSLATION:
			for (int i = 0; i < spreadsToSearch.size(); i++) {
				document = spreadsToSearch.get(i).getTranscription();
				addResults(queryText, document, isCaseSensitive);
			}
			break;
		case TextSearchConstants.ANNOTATION:
			for (int i = 0; i < spreadsToSearch.size(); i++) {
				document = spreadsToSearch.get(i).getAnnotation();
				addResults(queryText, document, isCaseSensitive);
			}
			break;
		case TextSearchConstants.ALLDOCUMENT:
			for (int i = 0; i < spreadsToSearch.size(); i++) {
				document = spreadsToSearch.get(i).getTranscription();
				addResults(queryText, document, isCaseSensitive);
				document = spreadsToSearch.get(i).getTranslation();
				addResults(queryText, document, isCaseSensitive);
				document = spreadsToSearch.get(i).getAnnotation();
				addResults(queryText, document, isCaseSensitive);
			}
			ArrayList<Presentation> arrList2 = (ArrayList<Presentation>) PresentationTree
					.getInstance().getPresentations();
			Iterator<Presentation> it2 = arrList2.iterator();
			while (it2.hasNext()) {
				addResults(queryText, (SmartDocument) it2.next(),
						isCaseSensitive);
			}
			break;
		}
		System.out.println("total hit:" + results.size() + "results");
	}

	private void addResults(String queryText, SmartDocument document,
			boolean isCaseSensitive) {
		String documentURI = document.getURI();
		// SML̃\[X
		String source = document.getSource();
		// SML̃\[XWysiWyg̃v[eLXgɕϊ
		String planeText = source2Text(source);
		// isCaseSensitive̒lɏ]queryText, planeTextϊ
		String ccQuery = convertCase(queryText, isCaseSensitive);
		String ccText = convertCase(planeText, isCaseSensitive);
		int lengthOfQuery = queryText.length();
		// ʂɕ\eLXg
		TextToShow textToShow;
		int indexOfResult;
		int i = 0;
		if (ccText == null) {
			return;
		}
		if (!(ccText.indexOf(ccQuery) == -1)) {
			while (true) {
				indexOfResult = ccText.indexOf(ccQuery, i);
				if (indexOfResult == -1) {
					i = 0;
					break;
				}
				SearchResult result = new SearchResult();
				result.setResult(queryText, documentURI, LEFTPAGE,
						indexOfResult);
				textToShow = textToShow(indexOfResult, lengthOfQuery, planeText);
				result.setTextToShow(textToShow);
				System.out.println("Hit:" + queryText); // eXgp
				System.out.println("index:" + indexOfResult);
				System.out.println("documentURI:" + documentURI);
				System.out.println("leftpage\\");
				System.out.println("text to show:" + textToShow);
				results.add(result);
				i = indexOfResult + 1;
			}
		}

		/*
		 * if(ccRightText == null){ return; }
		 * if(!(ccRightText.indexOf(ccQuery)==-1)){ while(true){ indexOfResult =
		 * ccRightText.indexOf(ccQuery,i); if(indexOfResult==-1){ i=0; break; }
		 * SearchResult result = new SearchResult();
		 * 
		 * result.setResult(queryText,documentURI,RIGHTPAGE, indexOfResult);
		 * textToShow = textToShow(indexOfResult,lengthOfQuery,rightPlaneText);
		 * result.setTextToShow(textToShow);
		 * System.out.println("Hit:"+queryText); //eXgp
		 * System.out.println("index:"+indexOfResult);
		 * System.out.println("documentURI:"+ documentURI);
		 * System.out.println("rightpage\\"); System.out.println("text to
		 * show:"+textToShow); results.add(result); i = indexOfResult+1; } }
		 */
	}

	private String source2Text(String source) {
		// smlSourceXMLInputSourceɕϊ
		/*
		 * InputSource is = new InputSource(new StringReader(source)); String
		 * planeText = null; try{ // SAXp[T[t@Ng𐶐 SAXParserFactory spfactory =
		 * SAXParserFactory.newInstance(); // SAXp[T[𐶐 SAXParser parser =
		 * spfactory.newSAXParser(); // nh[𐶐 TextSearchSax tss = new
		 * TextSearchSax(); // SMLsourcenh[ŏ parser.parse(is, tss);
		 * planeText = tss.getPlaneText(); } catch(Exception e){
		 * e.printStackTrace(); }
		 */
		String planeText = source;
		planeText = StringUtils.replaceString(planeText, "<br>", "\n");
		Pattern pattern = Pattern.compile("<.+?>", Pattern.DOTALL);
		Matcher matcher = pattern.matcher(planeText);
		planeText = matcher.replaceAll("");
		//2008/9/25 North Grid trim͕svɂȂ܂
		//planeText = planeText.trim();

		return planeText;
	}

	private String convertCase(String source, boolean isCaseSensitive) {
		if (source == null) {
			return null;
		}
		if (isCaseSensitive) {
			return source;
		}
		return source.toLowerCase();
	}

	/*
	 * WysiWyg̃eLXgŜ
	 * 
	 */
	private TextToShow textToShow(int index, int lengthOfQuery, String text) {
		String textToShow = text.substring(index, index + lengthOfQuery);
		String pre;
		String query;
		String fol;
		// NGO̕\镶
		final int num = 10;
		// eLXg̒
		int length = text.length();

		if (index + 1 <= num) {
			if (index == 0) {
				pre = "";
			} else {
				pre = text.substring(0, index);
			}
		} else {
			pre = "..." + text.substring(index - num, index);
		}
		query = text.substring(index, index + lengthOfQuery);
		if (length - index - lengthOfQuery <= num) {
			if (length - index - lengthOfQuery == 0) {
				fol = "";
			} else {
				fol = text.substring(index + lengthOfQuery);
			}
		} else {
			fol = text.substring(index + lengthOfQuery, index + lengthOfQuery
					+ num)
					+ "...";
		}
		textToShow = pre + query + fol;
		return new TextToShow(textToShow, pre.length(), lengthOfQuery);
	}

	public List<SearchResult> getResults() {
		return this.results;
	}
}
