/*
 * 쐬: 2004/07/04
 */
package jp.ac.hokudai.meme.core_smart_gs.ui;

import java.awt.Rectangle;
import java.util.ArrayList;

import jp.ac.hokudai.meme.core_smart_gs.searcher.*;

import org.eclipse.swt.graphics.*;


/**
 * @author hajime
 */
public class DocHighLighter {
    
	public static final PaletteData GREEN = new PaletteData(new RGB[]{new RGB(0,255,0)});
	public static final PaletteData BLUE = new PaletteData(new RGB[]{new RGB(0,0,255)});
	public static final PaletteData RED = new PaletteData(new RGB[]{new RGB(255,0,0)});
	
	public DocHighLighter(){
		
	}
	
	public void highLight(GC gc, PagedRect[] pRects, Device display, PaletteData pd){
        for (int i = 0; i < pRects.length; i++) {
            Rectangle drawArea = pRects[i].getRect();
            ImageData iData = new ImageData(drawArea.width, drawArea.height, 8, pd);
            iData.alpha = 64;
            int leftUpperX = drawArea.x;
            int leftUpperY = drawArea.y;
            gc.drawImage(new Image(display, iData), leftUpperX, leftUpperY);
        }
	}
	
    public void hitHighLight(GC gc , ResultRects resultRect, int pageNum, Device display){
        FoundRect[] rectsInPage = resultRect.getPRectsInPage(pageNum);
        
        for (int i = 0; i < rectsInPage.length; i++) {
            FoundRect rect = rectsInPage[i];
            highLight(gc, trimRectsInPage(rect, pageNum), display, DocHighLighter.BLUE);
        }
	}
    
    /**
     * @param rect
     * @param pageNum
     * @return
     */
    private PagedRect[] trimRectsInPage(FoundRect fRect, int pageNum) {
        PagedRect[] srcPRects = fRect.getPRects();
        ArrayList retList = new ArrayList();
        for (int i = 0; i < srcPRects.length; i++) {
            if (srcPRects[i].getPageIndex() == pageNum) {
                retList.add(srcPRects[i]);
            }
        }
        return (PagedRect[]) retList.toArray(new PagedRect[0]);
    }
    
}
