package smart_gs.drawing_tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.connection.ConnectionCreator;
import smart_gs.dictionary.DictionaryRegisterDialog;
import smart_gs.drawing_tool.action.AddRegionToNoteAction;
import smart_gs.drawing_tool.action.CreateNoteAction;
import smart_gs.drawing_tool.action.CreateShortCutAction;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.action.MemoPadTextAction;
import smart_gs.drawing_tool.action.ProtectRegionAction;
import smart_gs.drawing_tool.action.ReleaseProtectedRegionAction;
import smart_gs.drawing_tool.action.SetLinkSourceAction;
import smart_gs.drawing_tool.action.SetLinkTargetAction;
import smart_gs.logical.Region;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;

@SuppressWarnings("serial")
public class RightClickMenu extends JPopupMenu{	
	
	public RightClickMenu(final Region region) {
		JMenuItem delete = new JMenuItem("Delete");
		delete.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				new DeleteRegionAction(region).execute();
			}
		});
		this.add(delete);
		this.addSeparator();
		
		JMenuItem setSource = new JMenuItem("Set Link Source");
		setSource.addActionListener(new SetLinkSourceAction(region));
		this.add(setSource);
		
		JMenuItem setTarget = new JMenuItem("Set Link Target");
	    if(ConnectionCreator.isSourceSet()){
	    	setTarget.setEnabled(true);
	    	setTarget.addActionListener(new SetLinkTargetAction(region));
	    }else{
	    	setTarget.setEnabled(false);
	    }
	    
	    this.add(setTarget);

	    JMenuItem createShortcut = new JMenuItem("Create Short Cut");
	    createShortcut.addActionListener(new CreateShortCutAction(region));
	    //20080622 shimizu wrote
		//this.add(createShortcut);
		
		//this.addSeparator();
		
		JMenuItem createNote = new JMenuItem("Create Note");
		createNote.addActionListener(new CreateNoteAction(region));
		//20080622 shimizu wrote
		//this.add(createNote);
		
		JMenuItem addRegionToNote = new JMenuItem("Add to Previous Note");
		addRegionToNote.addActionListener(new AddRegionToNoteAction(region));
		//20080622 shimizu wrote
		//this.add(addRegionToNote);
		
		/*
		 * ǉ@kazuhiro kobayashi
		 */
		this.addSeparator();
		
		JMenuItem protectRegion = new JMenuItem("Protect Region");
		protectRegion.addActionListener(new ProtectRegionAction(region));
		this.add(protectRegion);
		
		JMenuItem releaseProtectedRegion = new JMenuItem("Release Protection of Region");
		releaseProtectedRegion.addActionListener(new ReleaseProtectedRegionAction(region));
		this.add(releaseProtectedRegion);
	
//		JMenuItem makeNewSheet = new JMenuItem("make new sheet");
//		makeNewSheet.addActionListener(new MakeNewSheetAction(region));
//		this.add(makeNewSheet);
		
		/*
		 * ǉ@tsukushi shimizu
		 */
		JMenuItem jump = new JMenuItem("Show Local View");
		if(!GS_RWRepository.getInstance().hasLink(region)){
			jump.setEnabled(false);
		}
		jump.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				new ShowLocalViewAction(region).execute();
			}
		});
		this.add(jump);
		
		
		/**
		 * eXg
		 */
		JMenuItem registDic = new JMenuItem("Register in the dictionary");
		registDic.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				DictionaryRegisterDialog dialog = new DictionaryRegisterDialog(WorkspaceWindow.getInstance(), "Register" , true,region);
				dialog.setVisible(true);
			}
		});
		this.add(registDic);
		
		JMenuItem addText = new JMenuItem("Add Text in MemoPad");
		addText.addActionListener(new MemoPadTextAction(region));
		this.add(addText);
		
	}
	
}
