package smart_gs.drawing_tool.state;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JOptionPane;

import smart_gs.connection.ConnectionCreator;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.RightClickMenu;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.action.AddPointAction;
import smart_gs.logical.Region;
import smart_gs.logical.LineSegment;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.DirectLinkPanel;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;

public class UniSelectedState implements State{
	
	private static UniSelectedState singleton = new UniSelectedState();
	
	private boolean rectangleMovable = false;
	
	private Point start,end;
	private Region selectedRegion;
	private UniSelectedState(){
		
	}
	public static UniSelectedState getInstance(){
		return singleton;
	}
	
	//20080715 shimizu wrote
	public boolean getRectangleMovability(){
		return this.rectangleMovable;
	}
	public void setRectangleMovability(boolean b){
		this.rectangleMovable = b;
	}
	
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
		if(this.selectedRegion == null){
			return;
		}
		if(e.getButton() == MouseEvent.BUTTON3){
				JPopupMenu menu = new RightClickMenu(this.selectedRegion);
				menu.show(e.getComponent(),e.getOriginalPoint().x,e.getOriginalPoint().y);
		}else if(e.getButton() == MouseEvent.BUTTON1){
			if(WorkspaceWindow.getInstance().isAlt() == true && WorkspaceWindow.getInstance().isCtrl() == true){
				new ShowLocalViewAction(this.selectedRegion).execute();
			}else if(WorkspaceWindow.getInstance().isAlt()){
				ConnectionCreator.setSource(this.selectedRegion);
			}else if(WorkspaceWindow.getInstance().isCtrl()){
				ConnectionCreator.setTarget(this.selectedRegion);
			}else if(WorkspaceWindow.getInstance().isShift()){
				if(this.selectedRegion.getView().getType()==this.selectedRegion.getView().LINE_SEGMENT){ //20101111 shimizu wrote;
					new AddPointAction((LineSegment)this.selectedRegion,e.getPoint2D()).execute();
					JOptionPane.showMessageDialog(new JFrame(),"exit");
				}
				else{
					JOptionPane.showMessageDialog(new JFrame(), "this region is not line segment");
				}
			}
		}
	}

	public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
		this.end = e.getPoint();
		
		if(rectangleMovable ==true){
			if(this.selectedRegion != null){
				Point2D p = new Point2D.Double(this.end.x-this.start.x,this.end.y-this.start.y);
				this.selectedRegion.getView().moveBy(p);
			}
		}
		this.start = this.end;
	}

	public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {

	}

	public void mouseExited(GSMouseEvent e, SpreadCanvas canvas) {

	}

	public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {

	}

	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		this.start = e.getPoint();
		boolean contains = canvas.containRegions(e.getPoint());
		if(e.getButton() == MouseEvent.BUTTON1){
			if((this.selectedRegion != null) && contains && e.isControlDown() && !(e.getButton()==MouseEvent.BUTTON3 && e.isShiftDown())){
				MultiSelectedState state = MultiSelectedState.getInstance();
				ImageLabel.setState(state);
				state.addSelectedRegion(this.selectedRegion);
				state.addSelectedRegion(canvas.getRegion(e.getPoint()));
				
				
			}
			//		RegiondȂĂꍇShiftL[ƓɃNbN邱ƂőIł
			else if(e.getButton() == MouseEvent.BUTTON1 &&contains && e.isShiftDown()){			
				if(this.selectedRegion != null){
					this.selectedRegion.getView().setIsSelected(false);
					//2007/10/30 kazuhiro kobayashi
					ReasoningWebFrame.getInstance().setLocalView(new DirectLinkPanel(null));
					ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
					GlobalViewPanel.getInstance().setSelectedElement(null);
					GlobalViewPanel.getInstance().repaint();
				}
				this.selectedRegion = canvas.getAnotherRegion(e.getPoint());
				this.selectedRegion.getView().setIsSelected(true);
				//2007/10/30 kazuhiro kobayashi
				ReasoningWebFrame.getInstance().setLocalView(new DirectLinkPanel(this.selectedRegion));
				ReasoningWebFrame.getInstance().getElementsPanel().setElement(this.selectedRegion);
				GlobalViewPanel.getInstance().setSelectedElement(this.selectedRegion);
				GlobalViewPanel.getInstance().repaint();
			}
			else if(contains){   //NbNꏊregion܂܂Ăꍇ
				if(this.selectedRegion != null){
					this.selectedRegion.getView().setIsSelected(false);
					//2007/10/30 kazuhiro kobayashi
					ReasoningWebFrame.getInstance().setLocalView(new DirectLinkPanel(null));
					ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
					GlobalViewPanel.getInstance().setSelectedElement(null);
					GlobalViewPanel.getInstance().repaint();
				}
				
				this.selectedRegion = canvas.getRegion(e.getPoint());
				this.selectedRegion.getView().setIsSelected(true);
				//2007/10/30 kazuhiro kobayashi
				ReasoningWebFrame.getInstance().setLocalView(new DirectLinkPanel(this.selectedRegion));
				ReasoningWebFrame.getInstance().getElementsPanel().setElement(this.selectedRegion);
				GlobalViewPanel.getInstance().setSelectedElement(this.selectedRegion);
				GlobalViewPanel.getInstance().repaint();
			}
			else{
				if(this.selectedRegion != null){
					this.selectedRegion.getView().setIsSelected(false);
					//2007/10/30 kazuhiro kobayashi
					ReasoningWebFrame.getInstance().setLocalView(new DirectLinkPanel(null));
					ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
					GlobalViewPanel.getInstance().setSelectedElement(null);
					GlobalViewPanel.getInstance().repaint();
				}
				this.selectedRegion = null;
				State state = DefaultState.getInstance();
			    ImageLabel.setState(state);
			    state.mousePressed(e, canvas);
			}
			
		}
	}

	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {

	}

	public void paint(Graphics g, SpreadCanvas canvas) {

	}
	public Region getSelectedRegion() {
		return this.selectedRegion;
	}
	
}
