package smart_gs.reasoning_web.logical;

import java.awt.Color;
import java.util.List;

import reasoning_web.logical.ChangeImpactAnalysis;
import reasoning_web.logical.ResourcePointer;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;

public class GSChangeImpactAnalysis extends ChangeImpactAnalysis{
	
	public GSChangeImpactAnalysis(GSResourcePointer changeSource) {
		super(changeSource);
	}
	
	@Override
	public void execute() {
		super.execute();
		this.clearColor();
		this.setViewColor();
		GlobalViewPanel.getInstance().repaint();
	}
	private void clearColor(){
		List<ResourcePointer> pointers = GS_RWRepository.getInstance().getResourcePointers();
		for(int i=0;i<pointers.size();i++){
			((GSResourcePointer)pointers.get(i)).getView().restoreDefaultColor();
		}
	}
	private void setViewColor(){

		Object[] keys = this.sortTable(this.table);		
		Color redColor = Color.red;
		int red = redColor.getRed();
		int green = 255;
		int blue = 255;
	
		for(int i=0;i<keys.length;i++){
			GSResourcePointer pointer = (GSResourcePointer)keys[keys.length-i-1];
			green = 30*i;
			blue = 30*i;
			Color color = new Color(red,green,blue);
			pointer.getView().setDrawColor(color);
			
		}		
	}
}
