package smart_gs.smleditor.swingui;

import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JToolBar;
import javax.swing.event.DocumentListener;

import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.AbstractEditorPanel;
import sml_editor.swingui.EditorMouseListener;


@SuppressWarnings("serial")
public class GSEditorPanel extends AbstractEditorPanel implements FocusListener{
	
	private GSEditorFrame parent;
	
	public GSEditorPanel(GSEditorFrame parent,GSEditorTextPane textPane) {
		super(parent,textPane);
		this.parent = parent;
		this.textPane.getGSHTMLEditorTextPane().addFocusListener(this);
	}
	@Override
	public DocumentListener getDocumentListener() {
		return new GSWysiwygDocumentListener((GSEditorTextPane)textPane);
	}
	@Override
	public EditorMouseListener getMouseListener() {
		return new GSWysiwygMouseListener((GSEditorTextPane)this.textPane);
	}
	@Override
	public void componentHidden(ComponentEvent e) {
		// no operation
	}
	@Override
	public void componentShown(ComponentEvent e) {
		// no operation
	}
	public void focusGained(FocusEvent e) {
//		this.textPane.learn();
		this.parent.setEditorTextPane(this.textPane);
	}
	public void focusLost(FocusEvent e) {
		
	}
	@Override
	public JToolBar getToolbar() {
		return new GSEditorToolBar((GSEditorTextPane)this.textPane);
	}
}
