package smart_gs.spread_selection;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;

import smart_gs.dictionary.DictionaryXML;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
/**
 * ͈́ispreadj̑Î߂̃plB
 * Ȃ̃WbNʂ̃NXɈڂƂlB
 * @author Administrator
 *
 */
public class SetScopePanel extends JPanel{
	private JRadioButton all;
	private JRadioButton currentDirectory;	
	private JRadioButton selectSpread;
	private JRadioButton imageDictionary;
	private JTextField pageSelectField;
	private JLabel pageSelectSample;
	private boolean imagemode = false;
	
	//20081031 North Grid Add
	private static boolean allSelected = true;
	private static boolean currentDirectorySelected = false;
	private static boolean selectSpreadSelected = false;
	private static boolean imageDictionarySelected = false;
	private static String pageSelectFieldText = "";
	
	private ScopePanelAction scopePanelAction;
	private SetScopePanel mySetScopePanel;
	
	public SetScopePanel(){
		this(false);
	}
	public SetScopePanel(boolean imagemode){
		this.imagemode = imagemode;
		if(!imagemode){
			allSelected = true;
			imageDictionarySelected = false;
		}
		this.setLayout(new GridLayout(6,1));
		this.setBorder(new TitledBorder("scope to search"));
		this.all = new JRadioButton("All Images");
		this.all.setSelected(allSelected);
		this.currentDirectory = new JRadioButton("Current Directory");
		this.currentDirectory.setSelected(currentDirectorySelected);
		
		this.selectSpread = new JRadioButton("Select Images");
		this.selectSpread.setSelected(selectSpreadSelected);

		this.pageSelectField = new JTextField(10);
		//this.pageSelectField.setEnabled(false);
		this.pageSelectField.setText(pageSelectFieldText);
		
		this.pageSelectSample = new JLabel("example: 2, 4, 6-10");
		
		this.imageDictionary = new JRadioButton("Image Dictionary");
		this.imageDictionary.setSelected(imageDictionarySelected);
		
		this.all.addActionListener(new ScopeSelectAction());
		this.selectSpread.addActionListener(new ScopeSelectAction());
		this.currentDirectory.addActionListener(new ScopeSelectAction());
		this.imageDictionary.addActionListener(new ScopeSelectAction());
	
		new ScopeSelectAction().actionPerformed(null);
		
		ButtonGroup group1 = new ButtonGroup();
		
		group1.add(this.all);
		group1.add(this.currentDirectory);
		group1.add(this.selectSpread);
		// ADD NorthGrid imagêݒǉ
		if(imagemode){
			group1.add(this.imageDictionary);
		}
		
		this.add(all);
		this.add(currentDirectory);
		this.add(selectSpread);
		this.add(pageSelectField);
		this.add(pageSelectSample);
		// ADD NorthGrid imagêݒǉ
		if(imagemode){
			this.add(imageDictionary);
		}
		this.mySetScopePanel = this;
		
	}
	public List<Spread> getSpreadsToSearch(){
		if(this.all.isSelected()){
			return SpreadTree.getInstance().getSpreads();
		}
		else if(this.currentDirectory.isSelected()){
			return SpreadTree.getInstance().getCurrentDirectory().getSpreads();
		}
		else if(this.selectSpread.isSelected()){
			String spreadSelection = this.pageSelectField.getText();
			SpreadSelector selector = new SpreadSelector( SpreadTree.getInstance().getSpreads(), spreadSelection);
			return selector.select();
		}else if(this.imageDictionary.isSelected()){
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
//			dictionaryXML.load(true);
			return dictionaryXML.getLoadSpreads();
		}
		return null;
	}
	public List<Spread> getDSCSpreads(List<Spread> spreads){
		List<Spread> results = new ArrayList<Spread>();
		for(int i=0;i<spreads.size();i++){
			if(spreads.get(i).hasDscFile()){
				results.add(spreads.get(i));
			}
		}
		return results;
	}
	public String getSelectedPage(){
		pageSelectFieldText = pageSelectField.getText();
		return this.pageSelectField.getText();
	}
	public class ScopeSelectAction implements ActionListener{
		public void actionPerformed(ActionEvent e){
			if(selectSpread.isSelected()){
				pageSelectField.setEnabled(true);
			}
			else if(all.isSelected() || currentDirectory.isSelected() || imageDictionary.isSelected()){
				pageSelectField.setEnabled(false);
			}
			allSelected = all.isSelected();
			currentDirectorySelected = currentDirectory.isSelected();
			selectSpreadSelected = selectSpread.isSelected();
			imageDictionarySelected = imageDictionary.isSelected();
			if(scopePanelAction != null){
				scopePanelAction.actionPerformed(mySetScopePanel);
			}
		}
	}
	/*
	 * 2008,0901. 
	 * plLE 
	 */
	public void setEnabled(boolean flag){
		all.setEnabled(flag);
		currentDirectory.setEnabled(flag);
		selectSpread.setEnabled(flag);
		pageSelectField.setEnabled(flag);
		pageSelectSample.setEnabled(flag);
		imageDictionary.setEnabled(flag);
	}
	
	public boolean isAll(){
		return this.all.isSelected();
	}
	public boolean isCurrentDirectory(){
		return this.currentDirectory.isSelected();
	}
	public boolean isSelectSpread(){
		return this.selectSpread.isSelected();
	}
	public boolean isImageDictionary(){
		return this.imageDictionary.isSelected();
	}
	public String  getPageSelectField(){
		return this.pageSelectField.getText();
	}
	public void setScopePanelAction(ScopePanelAction scopePanelAction) {
		this.scopePanelAction = scopePanelAction;
	}
	public void execScopePanelAction(){
		if(scopePanelAction != null){
			scopePanelAction.actionPerformed(mySetScopePanel);
		}
	}
	
}
