package smart_gs.util;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.ResourceSelectionState;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.swingui.ButtonDialog;

@SuppressWarnings("serial")
public class ResourceSelectionDialog extends ButtonDialog implements ResourceNotify{

	protected JTextField selectionField;
	private JTextField tempField;
	protected GSResource selectedResource;
	private JPanel mainPanel;
	
	public ResourceSelectionDialog(Frame parent,String title){
		super(parent,title);
		this.toFront();
		this.selectionField = new JTextField(20);
		this.tempField = new JTextField(20);
		JButton reference = new JButton("Reference");
		reference.addActionListener(new ReferenceAction());
		mainPanel = new JPanel(new GridLayout(2,1));
		JPanel panel = new JPanel();
		panel.add(this.selectionField);
		panel.add(reference);
		
		JPanel panel2 = new JPanel();
		JButton click = new JButton("select by click");
		click.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				addResource();
			}
		});
		panel2.add(click);
		
		mainPanel.add(panel);
		mainPanel.add(panel2);
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		
		this.pack();
	}
	private void addResource(){
		DefaultState.setDefaultState(ResourceSelectionState.getInstance());
		((ResourceSelectionState)ResourceSelectionState.getInstance()).addNotifyElement(this);
		this.select();
	}
	protected void restore(){
		this.getContentPane().removeAll();
		DefaultState.restoreDefaultState();
		this.selectionField.setText(this.tempField.getText());
//		this.selectionField.setText("");
		this.getContentPane().add(this.mainPanel,BorderLayout.CENTER);
		this.getContentPane().add(this.getButtonPanel(),BorderLayout.SOUTH);
		this.pack();
		this.validate();
	}
	public void select(){
		JPanel panel = new JPanel();
		panel.add(this.tempField);
		JButton restore = new JButton("OK");
		restore.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				restore();
			}
		});
		panel.add(restore);
		
		this.getContentPane().removeAll();
		this.getContentPane().add(panel);
		this.pack();
		this.validate();
	}
	
	
	
	public ResourceSelectionDialog(GSEditorFrame parent) {
		this(parent.getFrame(),"Select Region");
	}
	
	public void notifyResourceSelection(GSResource resource) {
		this.selectedResource = resource;
		this.tempField.setText(resource.getURI());
	}
	
	private class ReferenceAction implements ActionListener{
		public void actionPerformed(ActionEvent arg0) {
			new ResourcePanelFrame();
			
		}
	}

	@Override
	public void cancel() {
		this.dispose();
	}



	@Override
	public void ok() {
		GS_RWRepository.getInstance().register(this.selectedResource);
	}
}
