package sml_editor.swingui;

import java.awt.BorderLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentListener;

public abstract class AbstractEditorPanel extends JPanel implements ComponentListener{
	
	protected EditorTextPane textPane;
	protected DocumentListener docListener;
	protected EditorMouseListener mouseListener;
	private JScrollPane scrollPane;
	protected EditorFrame parent;
	
	public AbstractEditorPanel(EditorFrame parent,EditorTextPane textPane){
		this.textPane = textPane;
		this.parent = parent;
		this.setLayout(new BorderLayout());
		this.addComponentListener(this);
		this.docListener = this.getDocumentListener();
		this.mouseListener = this.getMouseListener();
		this.scrollPane = new JScrollPane();
		this.scrollPane.setViewportView(this.textPane);
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.add(scrollPane,BorderLayout.CENTER);
		this.textPane.getGSHTMLEditorTextPane().setDocumentListener(docListener);
		this.textPane.getGSHTMLEditorTextPane().setMouseListener(mouseListener);
	}
	public EditorTextPane getTextPane(){
		return this.textPane;
	}
	public void componentHidden(ComponentEvent e) {
		this.textPane.removeMouseListener(this.mouseListener);
		this.textPane.getGSHTMLEditorTextPane().getStyledDocument().removeDocumentListener(this.docListener);
	}

	public void componentMoved(ComponentEvent e) {
	}

	public void componentResized(ComponentEvent e) {
	}

	public void componentShown(ComponentEvent e) {
		this.scrollPane.setViewportView(this.textPane);
		this.docListener = this.getDocumentListener();
		this.mouseListener = this.getMouseListener();
		this.textPane.getGSHTMLEditorTextPane().setMouseListener(this.mouseListener);
		this.textPane.getGSHTMLEditorTextPane().setDocumentListener(this.docListener);
		this.validate();
		this.repaint();
	}
	public abstract JToolBar getToolbar();
	public abstract DocumentListener getDocumentListener();
	public abstract EditorMouseListener getMouseListener();
}
