package sml_editor.swingui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

import org.xml.sax.SAXException;


@SuppressWarnings("serial")
public class SourcePanel extends JPanel implements ComponentListener{
	
	private JTextArea textArea;
//	private SmlController controller;
	private EditorFrame parent;
	
	public SourcePanel(EditorFrame parent){
		this.textArea = new JTextArea();
		this.parent = parent;
//		this.controller = controller;
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setViewportView(this.textArea);
		scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		this.textArea.setLineWrap(true);
		this.setLayout(new BorderLayout());
		Font font = this.textArea.getFont().deriveFont((float)GSHTMLEditorTextPane.DEFAULT_FONT_SIZE);
		this.textArea.setFont(font);
		this.add(scrollPane,BorderLayout.CENTER);
		
		this.addComponentListener(this);
	}
	public void setSource(String source){
		this.textArea.setText(source);
	}
	public String getSource(){
		return this.textArea.getText();
	}
	public void componentHidden(ComponentEvent e) {
//		try {
//			this.controller.setSource(this.getSource());
//		} catch (SAXException se) {
//			se.printStackTrace();
//		}
		
	}
	public void componentMoved(ComponentEvent e) {
		
	}
	public void componentResized(ComponentEvent e) {
		
	}
	public void componentShown(ComponentEvent e) {
//		String source = this.controller.document2Source();
		parent.setEditorToolBar(new JToolBar());
//		this.setSource(source);
	}
	
	
}
