/* $Id: InputStreamThread.java 498 2012-05-14 17:38:59Z shayashi $ */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;

import smart_gs.image_search.ExternalSearchEngineController;

public class InputStreamThread extends Thread {
	
	public static final int TYPE_STDOUT = 0; // Wo͗pXbh
	public static final int TYPE_STDERR = 1;	// WG[o͗pXbh
	private final int outputType;	// Wo͗p̃XbhWG[o͗p̃Xbh̏ێ
	private BufferedReader br;
	private ExternalSearchEngineController.DscSearchThread caller;
	
	public InputStreamThread(InputStream is, int type, ExternalSearchEngineController.DscSearchThread dscSearcThread) {
		br = new BufferedReader(new InputStreamReader(is));
		outputType = type;
		caller = dscSearcThread;
	}

	public void run() {
		while (true) {
			try {
				String ret = br.readLine();
				if (ret != null) {
					if (outputType == TYPE_STDOUT) {
						caller.addSearchResult(ret);
					} else if (outputType == TYPE_STDERR) {
						System.out.println("Message from DscSearch: " + ret);
					}
				} else {
					break;
				}
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
	}
}

