package smart_gs.drawing_tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.CloseUpRectangleMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class DrawingModeSelectionPopupMenu extends JPopupMenu {
	
	public DrawingModeSelectionPopupMenu(GSMouseEvent e1) {
		final GSMouseEvent e0 = e1;
		JMenuItem none = new JMenuItem("<none>");
		none.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeNone);
			}
		});
		this.add(none);

		JMenuItem closeUp = new JMenuItem("Close Up");
		closeUp.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = CloseUpRectangleMode.getInstance();
				mode.setTemporary(true);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeCloseUpRectangle);
			}
		});
		this.add(closeUp);

		JMenuItem rect = new JMenuItem("Rectangle");
		rect.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = RectangleMode.getInstance();
				mode.setTemporary(false);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeRectangle);
			}
		});
		this.add(rect);

		JMenuItem marker = new JMenuItem("Marker");
		marker.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = MarkerMode.getInstance();
				mode.setTemporary(false);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeMarker);
			}
		});
		this.add(marker);

		JMenuItem polygon = new JMenuItem("Polygon");
		polygon.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = PolygonMode.getInstance();
				mode.setTemporary(false);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modePolygon);
			}
		});
		this.add(polygon);

		JMenuItem memo = new JMenuItem("MemoPad");
		memo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = MemoPadMode.getInstance();
				mode.setTemporary(false);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeMemoPad);
			}
		});
		this.add(memo);

		JMenuItem bookmark = new JMenuItem("Bookmark");
		bookmark.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = BookmarkMode.getInstance();
				mode.setTemporary(false);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeBookmark);
			}
		});
		this.add(bookmark);

		JMenuItem eraser = new JMenuItem("Eraser");
		eraser.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = EraserMode.getInstance();
				mode.setTemporary(false);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeEraser);
			}
		});
		this.add(eraser);		
	}
}
