/* $Id: ChangeBreadthAction.java 327 2011-08-30 12:59:17Z minao $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.swingui.WorkspaceWindow;

public class MemoPadChangeFontSizeAction implements ActionListener {
	private View view;
	private SpreadCanvas canvas;
	
	public MemoPadChangeFontSizeAction(SpreadCanvas canvas, Region region) {
		this.view = region.getView();
		this.canvas = canvas;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		int old_size = ((MemoPadView)view).getFontSize();
		try {
			String new_size = JOptionPane.showInputDialog("Please input a positive integer (not less than 10 or more than 30).", old_size);
			while (new_size == null || Integer.parseInt(new_size) < 10 || Integer.parseInt(new_size) > 30) {
				new_size = JOptionPane.showInputDialog("Please input a positive integer not less than 10 or more than 30.", old_size);
			}
			((MemoPadView)view).setFontSize(Integer.parseInt(new_size));
			WorkspaceWindow.setUpdated(true);
			ImageLabel.setRectangleVisible(true);
		} catch (NumberFormatException error) {
			JOptionPane.showMessageDialog(canvas.getRootPane(), "An inappropriate value!");
		}
	}

}
