/* $Id: BookmarkMode.java 702 2013-05-17 14:36:21Z minao $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.logical.Preference;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class BookmarkMode  extends DrawingModeAdapter {
	private Component startcomponent;
	private static Mode singleton = new BookmarkMode();
	
	private boolean temporary = false;

	public static Mode getInstance() {
		return singleton;
	}
	
	public void reset() {
		startcomponent = null;
	}
	
	@Override
	public boolean isTemporary() {
		return temporary;
	}
	@Override
	public void setTemporary(boolean sw) {
		temporary = sw;
	}
	
	@Override
	public void mouseExited(GSMouseEvent e, SpreadCanvas canvas){
		super.mouseExited(e, canvas);
		if (startcomponent == null)	startcomponent = e.getComponent();
	}
	
	@Override
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas){
		if (startcomponent != null && (startcomponent != e.getComponent())) return;
		super.mouseClicked(e, canvas);
		int x = (int)e.getPoint().getX();
		int y = (int)e.getPoint().getY();
		Point origin = new Point(x,y);
		BookmarkView view = new BookmarkView(origin, "", new Double(Preference.getInstance().getBookmarkSize()));
		BookmarkRegion region = new BookmarkRegion(canvas.getSpread(), view);
		region.setTemporary(this.isTemporary());
		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
		new ImageToolBarSetModeByMouseEvent().setMode(e,ImageToolBar.modeNone);
		canvas.addRegion(region);

		// 2013/03/23 kukita
		// The created region will be automatically selected.
		UniSelectedState.getInstance().changeSelectedRegions(region);

		reset();
	}
	@Override
	public boolean addingMarkup() {
		return true;
	}

}
