/* $Id: LabelMouseListener.java 626 2013-01-13 18:51:36Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

import javax.swing.JLabel;
import javax.swing.JWindow;

import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Spread;
import smart_gs.logical.region.RectangleRegion;
import smart_gs.menu.action.SpreadJumpAction;
import smart_gs.menu.action.SpreadOpenAction;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.WorkspaceWindow;
import sml_editor.logical.LineDirection;

public class LabelMouseListener extends MouseAdapter{
	
	private Spread spread;
	private Rectangle2D rect;
	private JWindow window;
	private JLabel label;
	private Point clickedPoint;
	
	public LabelMouseListener(JLabel label,JWindow window,Spread spread,Rectangle2D rect){
		this.label = label;
		this.spread = spread;
		this.rect = rect;
		this.window = window;
		this.window.pack();
	}
	public LabelMouseListener(JLabel label,Spread spread,Rectangle2D rect){
		this.label = label;
		this.spread = spread;
		this.rect = rect;
	}
	public void mouseClicked(MouseEvent e) {
		RectangleRegion rectreg = new RectangleRegion(spread,rect);
		if (e.getButton()==MouseEvent.BUTTON1) {
			if (WorkspaceWindow.getInstance().isAlt()) {
				/* alternative for right button click */
				SpreadJumpAction.jumpToTempRectangleRegion(rectreg);
			} else {
				SpreadOpenAction.openTempRectangleRegion(rectreg);
			}
		} if (e.getButton()==MouseEvent.BUTTON3)	{
			SpreadJumpAction.jumpToTempRectangleRegion(rectreg);
		}
	}
	
	public void mouseEntered(MouseEvent e) {
		label.setCursor(new Cursor(Cursor.HAND_CURSOR));
		if(this.window != null){
			Point p = label.getLocationOnScreen();
			if (this.spread.getLineDirection() == LineDirection.HORIZONTAL) {
				p = new Point(p.x-this.window.getWidth()/2,p.y-100);
			} else {
				p = new Point(p.x-80,p.y-this.window.getHeight()/2);
			}
			this.window.setLocation(p);
			this.window.setVisible(true);
		}
	}
	
	public void mouseExited(MouseEvent e) {
		label.setCursor(Cursor.getDefaultCursor());
		if(this.window != null){
			this.window.setVisible(false);
		}
	}
}