/* $Id: SpreadDirectory.java 506 2012-06-01 08:23:43Z ohura $ */
package smart_gs.logical;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Collections;

import javax.swing.tree.DefaultMutableTreeNode;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.GSConstants;
import smart_gs.logical.visitor.Visitor;
import smart_gs.util.GSStandardPath;

public class SpreadDirectory extends GSResource{
	
	private File imageFolder;	
	private List<GSResource> resources;
	private SpreadDirectory parent;
	
	
	
	public SpreadDirectory(String name,File imageFolder, String uri, String originalURI, String version){
		super();
		this.name = name;
		this.parent = null;
		this.imageFolder = imageFolder;
		this.resources = new ArrayList<GSResource>();
//		2011.03.28 shayashi deleted
//		//2007/11/20 kazuhiro kobayashi
//		this.systemName = name;
//		if(this.userName==null){
//			this.userName = name;
//		}
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}
	public List<GSResource> getResources(){
		return this.resources;
	}
	public void setResources(List<GSResource> newResources){
		this.resources = newResources;
	}
	public SpreadDirectory(SpreadDirectory parent,String name,File file, 
			String uri, String originalURI, String version){
		super();
		this.name = name;
		this.parent = parent;
		this.imageFolder = file;

		this.resources = new ArrayList<GSResource>();
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}

//	2011/05/20 kukita
	public SpreadDirectory(String name, File imageFolder) {
		super();
		this.name = name;
		this.parent = null;
		this.imageFolder = imageFolder;
		this.resources = new ArrayList<GSResource>();
		this.setURIs();
	}
//	2011/05/20 kukita
	public SpreadDirectory(SpreadDirectory parent, String name, File file) {
		super();
		this.name = name;
		this.parent = parent;
		this.imageFolder = file;
		this.resources = new ArrayList<GSResource>();
		this.setURIs();
	}
	
	
	public List<Spread> getSpreads(){
		List<Spread> results = new ArrayList<Spread>();
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				results.add((Spread)resource);
			}else if(resource instanceof SpreadDirectory){
				results.addAll(((SpreadDirectory)resource).getSpreads());
			}
		}
		return results;
	}
	public List<SpreadDirectory> getSpreadDirectorys(){
		List<SpreadDirectory> results = new ArrayList<SpreadDirectory>();
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof SpreadDirectory){
				results.add((SpreadDirectory)resource);
				results.addAll(((SpreadDirectory)resource).getSpreadDirectorys());
			}
		}
		return results;
	}
	public void addResource(GSResource resource){
		this.resources.add(resource);
	}
	public File getFile(){
		return this.imageFolder;
	}
	public String toString(){
//		2011.03.28 shayashi changed
		//2007/11/20 kazuhiro kobayshi
//		return this.userName;
		return this.name;
	}
	public String getPath() {
		String path = "";
		if(this.parent != null){
			path = this.parent.getPath();
		}else{
			return path;
		}
		return path+this.getName()+"/";
	}

	public void restore(Element element,File parentPath) {
		this.resources.clear();
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			Node node = nodes.item(i);
			if(node.getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)node;
				String tagname = elem.getNodeName();
				/*
				 *@ResourceɂΉB
				 */
				if(tagname.equals("spread")){
					Spread spread = XML2ResourceConverter.getSpread(this,parentPath, elem);
					SpreadTree.getInstance().registerSpread(spread);
					this.addResource(spread);
				}else if(tagname.equals("directory")){
					String name = elem.getAttribute(GSResource.NAME);
					String uri = elem.getAttribute(GSResource.URI);
					String originalURI = elem.getAttribute(GSResource.ORIGINAL_URI);
					String version = elem.getAttribute(GSResource.VERSION);
					String[] token = GSStandardPath.standardizeDirName(elem.getAttribute("filename")).split("/");
					String dirname = token[token.length-1];
					File dirpath = new File(parentPath,dirname);
					SpreadDirectory directory = new SpreadDirectory(this,name,dirpath,uri,originalURI,version);
					SpreadTree.getInstance().registerSpreadDirectory(directory);
					this.addResource(directory);
					directory.setURI(uri);
					directory.restore(elem,dirpath);
				}
			}
		}
	}
	public void setTree(DefaultMutableTreeNode parent){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				parent.add(new DefaultMutableTreeNode(resource));
			}else if(resource instanceof SpreadDirectory){
				DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(resource);
				parent.add(newNode);
				((SpreadDirectory)resource).setTree(newNode);
				
			}
		}
	}
	
	public void remove(Spread  spread){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				if(resource.getURI().equals(spread.getURI())){
					resources.remove(i);
					break;
				}
			}else if(resource instanceof SpreadDirectory){
				((SpreadDirectory)resource).remove(spread);
			}
		}
	}
	public void removeDirectory(SpreadDirectory spreadDirectory){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof SpreadDirectory){
				if(resource.getURI().equals(spreadDirectory.getURI())){
					resources.remove(i);
					break;
				}
				((SpreadDirectory)resource).removeDirectory(spreadDirectory);
			}
		}
	}
	public void removeAllChildren(){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				resources.remove(i);
			}else if(resource instanceof SpreadDirectory){
				((SpreadDirectory)resource).removeAllChildren();
				resources.remove(i);
			}
		}
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	
	public void sort(){
		Collections.sort(resources, new Comparator<GSResource>() {   
			public int compare(GSResource o1, GSResource o2) {
				if((o1 instanceof Spread) && (o2 instanceof Spread)){
					if(((Spread)o1).getPageViewIndex() > ((Spread)o2).getPageViewIndex()){
						return 1;
					}else{
						return -1;
					}
				}
				return 0;
			}
		});   
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.SPREAD_DIRECTORY;
	}
	public SpreadDirectory getParent() {
		return this.parent;
	}
	public String createOldVersionURI() {
		if (this.parent == null) {
			return GSConstants.URI_HEADER;
		} else {
			return this.parent.createOldVersionURI() + this.name + File.separator;
		}
	}

	public void clear() {
		this.resources.clear();
	}
	
}
