package smart_gs.network;

import java.awt.event.ActionEvent;
import java.io.IOException;

import javax.swing.AbstractAction;
import javax.swing.Action;

import smart_gs.debugprint.Debugprint;

import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectAction extends AbstractAction {

	static final String OPEN = Constants.OPEN;
	static final String AUTHENTICATE = Constants.AUTHENTICATE;	
	static final String UPDATE = Constants.UPDATE;
	static final String UPLOAD = Constants.UPLOAD;
	static final String REGISTER = Constants.REGISTER;
//	static final String RENAME = Constants.RENAME;
	static final String DOWNLOAD = Constants.DOWNLOAD;
	static final String SAVE_AS = Constants.SAVE_AS;
	static final String NEW = Constants.NEW;
	static final String COMPARE = Constants.COMPARE;
	static final String REMOVE = Constants.REMOVE;
	static final String HISTORY = Constants.HISTORY;
	
	static final String FETCH = Constants.FETCH;
//	static final String DELETE = Constants.DELETE;
	static final String ADD_IMAGE = Constants.ADD_IMAGE;
	static final String DOWNLOAD_IMAGE = Constants.DOWNLOAD_IMAGE;
	static final String NONE = Constants.NONE;
	static final String ADD_ATTACHMENT = Constants.ADD_ATTACHMENT;
	static final String RESISTER_IMAGE = Constants.RESISTER_IMAGE;

	
	public ProjectAction(String name) {
		putValue(Action.NAME, name);
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		String name = (String) this.getValue(Action.NAME);
		HCPProject projectInWorkspace = ProjectExplorer.getInstance().getSelectedProjectInWorkspace();
		HCPProject projectInRepository = ProjectExplorer.getInstance().getSelectedProjectInRepository();
		ProjectHandler handler = ProjectHandler.getInstance();
		handler.setProjectInWorkspace(projectInWorkspace);
		handler.setProjectInRepository(projectInRepository);
		handler.setAction(name);
		if (name.equals(AUTHENTICATE)) {
			handler.authenticate();
		} else if (name.equals(OPEN)) {
			handler.open(projectInWorkspace);
		} else if (name.equals(REGISTER)) {
			Debugprint.from();
			Debugprint.message("Register project: " + projectInWorkspace.name);
			handler.register();
		} else if (name.equals(UPLOAD)) {
			handler.upload();
		} else if (name.equals(UPDATE)) {
			handler.update();
		} else if (name.equals(DOWNLOAD)) {
			handler.download();
		} else if (name.equals(SAVE_AS)) {
			handler.saveAs();
		} else if (name.equals(COMPARE)) {
			handler.compare();
		} else if (name.equals(NEW)) {
			handler.create();
		} else if (name.equals(REMOVE)) {
			handler.remove();
		} else if (name.equals(FETCH)) {
			handler.fetchContents();
		} else if (name.equals(ADD_IMAGE)) {
			handler.addImages();
//		} else if (name.equals(DELETE)) {
//			handler.delete();
		} else if (name.equals(HISTORY)) {
			handler.history();
		}

	}
	
}
