package smart_gs.network;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

import smart_gs.logical.Preference;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class RepositoryMenu extends JMenu {

	public RepositoryMenu(String title, AbstractGSWindow parent){
		super(title);
		
		JMenu project = new JMenu("Project");
		this.add(project);
		
		JMenuItem explorer = new JMenuItem("Project Explorer");
		project.add(explorer);
		explorer.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				ProjectExplorer.getInstance().setVisible(true);
			}
		});
				
		JMenuItem upload = new JMenuItem("Upload Current Project");
		project.add(upload);
		upload.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				//TODO
			}
		});
		
		JMenuItem update = new JMenuItem("Update Current Project");
		project.add(update);
		update.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				//TODO
			}
		});
		JMenu image = new JMenu("Image");
		this.add(image);
		
		JMenuItem addToImageServer = new JMenuItem("Add to Image Server");
		image.add(addToImageServer);
		addToImageServer.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				new ImageRegisterDialog(WorkspaceWindow.getInstance()).setVisible(true);				
			}
		});

		JMenu downloadImage = new JMenu("Download");
		image.add(downloadImage);
		JMenuItem byGroupID = new JMenuItem("Use Group ID");
		byGroupID.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if (ProjectHandler.getInstance().authenticated()) {
					new SelectGroupFrame(ProjectAction.DOWNLOAD_IMAGE).setVisible(true);
				} else {
					ProjectHandler.getInstance().authenticate();
				}
			}
		});
		JMenuItem byUserID = new JMenuItem("Use User ID");
		byUserID.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				String id = Preference.getInstance().getUserName();
				new ImageDownloadDialog(id).setVisible(true);				
			}
		});
		downloadImage.add(byGroupID);
		downloadImage.add(byUserID);

		
		
		JMenuItem addToProject = new JMenuItem("Add to Project");
		image.add(addToProject);
		addToProject.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				ProjectHandler.getInstance().setAction(Constants.ADD_IMAGE);
				ProjectHandler.getInstance().addImages();
			}
		});
		
		
		JMenuItem attachment = new JMenuItem("Attachment");
		attachment.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				ProjectHandler.getInstance().setAction(Constants.ADD_ATTACHMENT);
				ProjectHandler.getInstance().addAttachment();	
			}
			
		});
		this.add(attachment);
	}
	
}
