//This class is no longer in use.
package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import jp.ac.nii.hcp.client.core.HCPController;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.ProjectDifference;

import smart_gs.debugprint.Debugprint;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.WorkspaceWindow;

public class SelectProjectFrame extends ButtonFrame implements ListSelectionListener, ActionListener {
	private JList list;

	public SelectProjectFrame(Frame parent, JList projectList, 
			String action) {
		super(parent, action + ": Select Project");
		this.setSize(new Dimension(300, 300));
		this.list = projectList;
		JPanel panel = (JPanel) this.getContentPane();
		list.addListSelectionListener(this);
		JScrollPane sPane = new JScrollPane(list);
	    panel.add(sPane,BorderLayout.NORTH);
	}

	@Override
	public void ok() {
		HCPProject project = this.getSelectedProject();
		WorkspaceWindow.getInstance().restoreProject(project);
		this.dispose();
	}

	private HCPProject getSelectedProject() {
		int index = this.list.getSelectedIndex();
		String name = (String) this.list.getModel().getElementAt(index);
		Debugprint.from();
		Debugprint.message("selected project: " + name);
		ProjectHandler handler = ProjectHandler.getInstance();
		List<HCPProject> projects = handler.getProjectsFromWorkspace();
		for (int i = 0; i < projects.size();i++) {
			Debugprint.message("projects.get(i).name: " + projects.get(i).name);
			if (name.equals(projects.get(i).name)) {
				return projects.get(i);
			}
		}
		return null;
	}

	@Override
	public void cancel() {
		this.dispose();
	}

	@Override
	public void valueChanged(ListSelectionEvent e) {
		
	}
}