/* $Id: GlobalViewMouseListener.java 561 2012-09-05 04:28:55Z shayashi $ */
/*
 * 쐬: 2006/06/02
 *
 */
package smart_gs.reasoning_web.swingui.mouse_listener;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

import javax.swing.SwingUtilities;

import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.reasoning_web.swingui.DirectLinkPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.reasoning_web.swingui.action.ConnectionRightClickMenu;
import smart_gs.reasoning_web.swingui.action.PointerRightClickMenu;
import smart_gs.reasoning_web.swingui.view.View;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.Connection;
import smart_gs.reasoning_web.swingui.action.ConnectionRightClickMenu;
import smart_gs.swingui.WorkspaceWindow;

/**
 * @author kazuaki kobayashi
 * 
 * 
 */
// Ẽplł̃}EX̑
public class GlobalViewMouseListener implements MouseListener,
		MouseMotionListener {

	private Point2D start = null;
	private Point2D end = null;

	private GS_RWElement selectedElement;
	private View selectedView;

	//2007/11/19 kazuhiro kobayashi
	private final Rectangle rect = new Rectangle();

	public void mouseClicked(MouseEvent e) {
		this.start = e.getPoint();

		GS_RWElement element = (GS_RWElement) GlobalViewPanel.getInstance()
				.getElement(e.getPoint());
		if (e.getButton() == MouseEvent.BUTTON3 ||
				/* alternative for right button click */
				(e.getButton() == MouseEvent.BUTTON1 & WorkspaceWindow.getInstance().isAlt())) {
			ResourcePointer pointer = GlobalViewPanel.getInstance()
					.getResourcePointer(e.getPoint());
			if (pointer != null) {
				PointerRightClickMenu pmenu = new PointerRightClickMenu(pointer);
				pmenu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
			} else {
				Connection connection = GlobalViewPanel.getInstance()
						.getConnection(e.getPoint());
				if (connection != null) {
					ConnectionRightClickMenu cmenu = new ConnectionRightClickMenu(
							(GS_RWElement) connection);
					cmenu
							.show(e.getComponent(), e.getPoint().x, e
									.getPoint().y);
				}
			}
		}
		//
		if (element == null) {
			this.selectedElement = null;
			return;
		}

		this.selectedElement = element;
		if (e.getClickCount() == 2) {
			element.show();
			return;
		}

		GS_RWRepository.getInstance();

	}

	public GS_RWElement getSelectedElement() {
		return this.selectedElement;
	}

	// 2007/10/30 kazuhiro kobayashi
	public void setSelectedElement(GS_RWElement element) {
		this.selectedElement = element;

	}

	public void mouseEntered(MouseEvent e) {

	}

	public void mouseExited(MouseEvent e) {

	}

	public void mousePressed(MouseEvent e) {

		this.start = e.getPoint();

		if (this.selectedView != null) {
			if (!this.selectedView.contains(e.getPoint())) {
				this.selectedView.setIsSelected(false);
				this.selectedView = null;
				this.selectedElement = null;

			}
		}

		View view = GlobalViewPanel.getInstance().getView(e.getPoint());

		this.selectedElement = (GS_RWElement) GlobalViewPanel.getInstance()
				.getElement(e.getPoint());

		if (view == null) {

			return;
		}
		view.setIsSelected(true);
		this.selectedView = view;

		ReasoningWebFrame.getInstance().getElementsPanel().setElement(
				this.selectedElement);
		GlobalViewPanel.getInstance().repaint();
	}

	public void mouseReleased(MouseEvent e) {
		this.start = null;
		this.end = null;

		//2007/11/19 kazuhiro kobayashi
		GlobalViewPanel.getInstance().setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		GlobalViewPanel.getInstance().repaint();
		//
	}

	public void mouseDragged(MouseEvent e) {
		this.end = e.getPoint();
		
		if (this.selectedView == null) {

			//2007/11/19 kazuhiro kobayashi
			GlobalViewPanel.getInstance().setCursor(
					new Cursor(Cursor.HAND_CURSOR));
			Rectangle r = GlobalViewPanel.getInstance().getVisibleRect();
			this.rect.setRect(r.x - this.end.getX() + this.start.getX(), r.y
					- this.end.getY() + this.start.getY(), r.getWidth(), r
					.getHeight());
			GlobalViewPanel.getInstance().scrollRectToVisible(this.rect);
			//
			
			return;
		}

		// 2007/11/1 kazhiro kobayashi
		if (this.end.getX() <= 0) {
			this.end.setLocation(5, this.end.getY());
		}
		if (this.end.getY() <= 0) {
			this.end.setLocation(this.end.getX(), 5);
		}
		Point2D point = new Point2D.Double(end.getX() - start.getX(), end
				.getY()
				- start.getY());
		this.selectedView.moveBy(point);
		this.start = this.end;
		GlobalViewPanel.getInstance().repaint();

		// 2007/11/1 kazuhiro koabayshi
		GlobalViewPanel.getInstance().setGlobalViewPanelSize(this.end);
	}

	public void mouseMoved(MouseEvent e) {

	}

}
