/* $Id: SpreadSelectionTreeFrame.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.spread_selection;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class SpreadSelectionTreeFrame {
	
	private final SpreadSelectionTree tree;
	private final JFrame frame;

	public SpreadSelectionTreeFrame() {
		super();
		tree = new SpreadSelectionTree();
		frame = new JFrame("Selection of Spreads by Tree");
		JPanel button_panel = new JPanel();
		JButton save = new JButton("Save");
		save.addActionListener(new GUISaveSpreadSelectionListAction(tree));
		button_panel.add(save);
		JButton read = new JButton("Read");
		read.addActionListener(new GUIReadSpreadSelectionListAction(tree));
		button_panel.add(read);
		JButton show = new JButton("Show");
		show.addActionListener(new GUIShowSpreadSelectionListsAction(show));
		button_panel.add(show);
		SpreadSelectionTreePanel sslPanel = new SpreadSelectionTreePanel(tree);
		frame.getContentPane().add(sslPanel, BorderLayout.CENTER);
		frame.getContentPane().add(button_panel, BorderLayout.SOUTH);
		frame.setSize(600, 300);
		frame.setVisible(true);
	};

	

	
	/**
	 * @return the frame
	 */
	public JFrame getSpreadSelectionTreeFrame() {
		return frame;
	}
}
