/* $Id: ToolBarPanel.java 640 2013-01-29 14:34:28Z shayashi $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import smart_gs.GSConstants;
import smart_gs.swingui.toolbar.DefaultToolBar;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.UtilityToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;
import sml_editor.logical.LineDirection;
import sml_editor.swingui.EditorTextPane;
@SuppressWarnings("serial")
public class ToolBarPanel extends JPanel{
	
	private GSEditorToolBar editorToolBar;
	private HistoryToolBar historyToolBar;
	private MoveTreeToolBar moveTreeToolBar;
	private ImageToolBar imageToolBar;
	private static JLabel horizontalLineTextIcon = null;
	private static JLabel verticalLineTextIcon = null;
	private static JLabel undefinedLineTextIcon = null;
	private JLabel lineTextIcon = null;
	private UtilityToolBar utilityToolBar;


	public ToolBarPanel(AbstractGSWindow parent, boolean isInWorkspaceWindow){
//		super(new GridLayout(1,1));
		super(new BorderLayout());
		
		if (horizontalLineTextIcon == null) {
			try {
				horizontalLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/horizontal.png"))));
			} catch (IOException e) {
				System.out.println("Failed to read horizontal.png");
			}
		}
		
		if (verticalLineTextIcon == null) {
			try {
				verticalLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/vertical.png"))));
			} catch (IOException e) {
				System.out.println("Failed to read vertical.png");
			}
		}
		
		if (undefinedLineTextIcon == null) {
			try {
				undefinedLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/undefined.png"))));
			} catch (IOException e) {
				System.out.println("Failed to read undefined.png");
			}
		}
		
		
//		lineTextIcon = undefinedLineTextIcon;
//		this.add(lineTextIcon, BorderLayout.WEST);
		
		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		if (isInWorkspaceWindow) panel1.add(new DefaultToolBar());
		imageToolBar = new ImageToolBar(parent);
		panel1.add(imageToolBar);
		panel1.add(new SearchToolBar(parent));
		panel1.validate();
		this.add(panel1,BorderLayout.CENTER);
		this.validate();

		this.utilityToolBar = new UtilityToolBar(parent,isInWorkspaceWindow);
		panel1.add(this.utilityToolBar);
		
		if (isInWorkspaceWindow) {
			historyToolBar = new HistoryToolBar(parent);
			panel1.add(historyToolBar);
		}
		
		moveTreeToolBar = new MoveTreeToolBar(parent);
		panel1.add(moveTreeToolBar);
		
		panel1.validate();

		this.add(panel1);
		this.validate();
	}
	
	public void setLineDirectionIcon(LineDirection direction) {
		if (lineTextIcon != null) this.remove(lineTextIcon);
		if (direction == LineDirection.HORIZONTAL) {
			lineTextIcon = horizontalLineTextIcon;
		}
		
		if (direction.equals(LineDirection.VERTICAL)) {
			lineTextIcon = verticalLineTextIcon;

		} 
		
		if (direction.equals(LineDirection.UNDEFINED)){
			lineTextIcon = undefinedLineTextIcon;
		}
		
	    this.add(lineTextIcon,BorderLayout.WEST);
	    this.validate();
	}


	public GSEditorToolBar getGSEditorToolBar(){
		return editorToolBar;
	}
	public HistoryToolBar getHistoryToolBar(){
		return historyToolBar;
	}
	public MoveTreeToolBar getMoveTreeToolBar(){
		return moveTreeToolBar;
	}
	public ImageToolBar getImageToolBar() {
		return imageToolBar;
	}
	
	public UtilityToolBar getUtilityToolBar() {
		return utilityToolBar;
	}
}
