package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JOptionPane;

import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.action.LineSegEditorChangeIndexesResultLinesMaker;

public class LineSegEditorChangeIndexesActionListener implements ActionListener {
	LineSegEditor editor;
	
	public LineSegEditorChangeIndexesActionListener(LineSegEditor editor) {
		this.editor = editor;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		editor.pushUndoStack();
		String input = JOptionPane.showInputDialog("Indexes of line segments to change:", "");
		if(input == null){
			return;
		}

		LineSegEditorChangeIndexesResultLinesMaker mkr = new LineSegEditorChangeIndexesResultLinesMaker(input,this.editor.getLinesForEdit());

		mkr.process();
		if (mkr.isCanceled()) return;
		this.editor.setLinesForEdit(mkr.getLines());
		this.editor.rewriteLineSegIndexes();
		this.editor.invalidate();
		this.editor.validate();
		this.editor.repaint();
	}
}
