package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JOptionPane;

import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;

public class LineSegEditorDeleteActionListener implements ActionListener {
	LineSegEditor editor;

	public LineSegEditorDeleteActionListener(LineSegEditor editor) {
		this.editor = editor;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		String input = JOptionPane.showInputDialog("Indexes of line segments to delete:", "");
		if(input == null){
			return;
		}

		LineSegEditorDeleteResultLinesMaker mkr = new LineSegEditorDeleteResultLinesMaker(input,this.editor.getLinesForEdit());
		mkr.process();
		if (mkr.isCanceled()) return;
		this.editor.pushUndoStack();
		this.editor.setLinesForEdit(mkr.getLines());
		this.editor.rewriteLineSegIndexes();
		this.editor.invalidate();
		this.editor.validate();
		this.editor.repaint();
	}
}

