package smart_gs.swingui.toolbar.action;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorSelectMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorTiltImagePanelLevelLineMode;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.util.GSLog;

public class LineSegEditorTiltImagePanelTiltActionListener implements ActionListener {
	LineSegEditor editor;

	public LineSegEditorTiltImagePanelTiltActionListener(LineSegEditor editor) {
		this.editor = editor;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		LineSegEditorTiltImagePanel tiltpanel = editor.getTiltPanel();
		double newdegree = tiltpanel.getDegree();
		tiltpanel.restoreOldDegree();
		editor.pushUndoStack();
		tiltpanel.setDegree(newdegree);
		this.editor.tilt();
		this.editor.setMode(new LineSegEditorSelectMode(this.editor));
	}

}