package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.DSCFileMaker;
import sml_editor.logical.LineDirection;

public class SaveLineSegmentsAction implements ActionListener {
//	TODO@shayashi 2011.06.19 to write!!!
	private LineSegEditor editor;
	private Spread spread;
	public SaveLineSegmentsAction(LineSegEditor parent){
		this.editor = parent;
	}

	public void actionPerformed(ActionEvent e) {
		this.spread = this.editor.getSpread();
		List<LineSegmentForEdit> segments = editor.getLinesForEdit();
		if(segments == null){
			return;
		}
		String folderPath = Spread.DSC_FOLDER_PATH+spread.getSpreadDirParent().getPath();
		String filename = spread.getFileNameWithoutExtension();
		String filetype = spread.getFileNameExtension();
		String lineDirectionType;
		if (spread.getLineDirection() == LineDirection.HORIZONTAL) {
			lineDirectionType = "HORIZONTAL";
		} else if (spread.getLineDirection() == LineDirection.VERTICAL) {
			lineDirectionType = "VERTICAL";
		} else {
			lineDirectionType = "UNDEFINED";
		}
		new DSCFileMaker(spread).saveLineSegments(segments, folderPath, filename, filetype, lineDirectionType);
	}
}

