package smart_gs.swingui.tree.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.filter.ImageFileFilter;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSStandardPath;

public class MakeNewSpreadDirectoryAction implements ActionListener {
	DefaultMutableTreeNode openDirectory;
	SpreadTree tree;
	
	public MakeNewSpreadDirectoryAction(DefaultMutableTreeNode secifiedDirNode, SpreadTree tree) {
		openDirectory = secifiedDirNode;
		this.tree = tree;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		String newDirName;
		newDirName = (String)JOptionPane.showInputDialog("Input Directory Name:\n");
		if (newDirName == null) return;
		tree.makeNewSpreadDirectory(openDirectory, newDirName);
		tree.expandRow(0);
		WorkspaceWindow.setUpdated(true);
	}
}
