package demo.wala;

import java.util.Iterator;
import java.util.Map;

import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.Slicer.ControlDependenceOptions;
import com.ibm.wala.ipa.slicer.Slicer.DataDependenceOptions;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.io.FileProvider;

import demo.util.DemoUtil;
import demo.util.MemoryInfo;

public class ControlAndDataDependencePerformance {

	public static void main(String[] args) throws Exception {
		long start = System.currentTimeMillis();

		AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(args[0], (new FileProvider()).getFile(DemoUtil.REGRESSION_EXCLUSIONS));
		ClassHierarchy cha = ClassHierarchy.make(scope);
		Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha);
		AnalysisCache cache = new AnalysisCache();
		AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
		CallGraphBuilder builder = Util.makeZeroCFABuilder(options, cache, cha, scope);
		CallGraph cg = builder.makeCallGraph(options, null);
		PointerAnalysis<InstanceKey> pa = null;

		for (CGNode node: cg) {
			DataDependenceOptions dOptions = DataDependenceOptions.NO_HEAP_NO_EXCEPTIONS;
			ControlDependenceOptions cOptions = ControlDependenceOptions.NO_EXCEPTIONAL_EDGES;
			ModRef modRef = ModRef.make();
			HeapExclusions exclusions = null;
			Map<CGNode, OrdinalSet<PointerKey>> mod = null;
			Map<CGNode, OrdinalSet<PointerKey>> ref = null;
			PDG pdg = new PDG(node, pa, mod, ref, dOptions, cOptions, exclusions, cg, modRef);
			for (Iterator<Statement> statements = pdg.iterator(); statements.hasNext();) {
				Statement s1 = statements.next();
				for (Iterator<Statement> succs = pdg.getSuccNodes(s1); succs.hasNext();) {
					Statement s2 = succs.next();
//					System.out.println(s1.toString() + " -> " + s2.toString());
				}
			}
		}

		long end = System.currentTimeMillis();

		System.err.println((end - start) + " [ms]");
		System.err.println(MemoryInfo.getMemoryInfo());
	}

}
