package demo.soba;

import demo.util.MemoryInfo;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.util.IntPairProc;
import soba.util.files.ClasspathUtil;
import soba.util.graph.DirectedGraph;

public class ControlDependencePerformance {

	public static void main(String[] args) {
		args = new String[]{"bin/demo/testdata"};
		
		long start = System.currentTimeMillis();
		
		JavaProgram program = new JavaProgram(ClasspathUtil.getClassList(args));
		for (ClassInfo c: program.getClasses()) {
			for (MethodInfo m: c.getMethods()) {
				DirectedGraph cd = m.getControlDependence();
				cd.forEachEdge(new IntPairProc() {
					@Override
					public boolean execute(int elem1, int elem2) {
//						System.out.println(elem1 + " -> " + elem2);
						return true;
					}
				});
			}
		}
		
		long end = System.currentTimeMillis();
		
		System.out.println((end - start) + " [ms]");
		System.out.println(MemoryInfo.getMemoryInfo());
	}

}
