package demo.soot;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import demo.util.DemoUtil;
import demo.util.MemoryInfo;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Transform;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class DataDependencePerformance {

	public static void main(String[] args) {
		List<String> argsList = Arrays.asList(new String[]{
				"-cp",
				"bin" + File.pathSeparator + 
				"bin/demo/testdata" + File.pathSeparator + 
				DemoUtil.RT_PATH + File.pathSeparator +
				DemoUtil.JCE_PATH,
				"-whole-program",
				"-main-class",
				"demo.testdata.TestClass",//main-class
//				"-app",
//				"demo.testdata.TestClass",
//				"demo.testdata.TestClass",//argument classes
				"-p",
				"cg.cha",
				"apponly:true,verbose:true",
				"demo.testdata.TestClass"
//				"-keep-line-number"
		});
		
		PackManager.v().getPack("jap").add(new Transform("jap.myTransform", new BodyTransformer() {
			@Override
			protected void internalTransform(Body body, String phase, Map options) {
//				UnitGraph graph = new ExceptionalUnitGraph(body);
				UnitGraph graph = new BriefUnitGraph(body);
				LiveLocals live = new SimpleLiveLocals(graph);
				LocalDefs defs = new SmartLocalDefs(graph, live);

				for (Unit u: body.getUnits()) {
					for (ValueBox vb: u.getUseBoxes()) {
						Value v = vb.getValue();
						if (v instanceof Local) {
							List<Unit> defUnits = defs.getDefsOfAt((Local) v, u);
							for (Unit def: defUnits) {
//								System.out.println(def.toString() + " -> " + u.toString());
							}
						}
					}
				}
			}
		}));
//		Options.v().set_verbose(true);
		PhaseOptions.v().setPhaseOption("jap.npc", "on");
		
		args = argsList.toArray(new String[0]);
		
		long start = System.currentTimeMillis();
		soot.Main.main(args);
		long end = System.currentTimeMillis();
		
		System.out.println((end - start) + " [ms]");
		System.out.println(MemoryInfo.getMemoryInfo());
	}

}
