package demo.wala;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

import com.ibm.wala.classLoader.ShrikeBTMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;

import demo.util.DemoUtil;

public class SlicerMain {

	public static void main(String[] args) {
		try {
			if (args.length > 0) {
				doSlicing(args[0]);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void doSlicing(String appJar) throws WalaException, IOException, IllegalArgumentException, CancelException {
		// create an analysis scope representing the appJar as a J2SE application
//		AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar,CallGraphTestUtil.REGRESSION_EXCLUSIONS);
//		AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, null);
//		AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar,new File(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
		AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, (new FileProvider()).getFile(DemoUtil.REGRESSION_EXCLUSIONS));

		ClassHierarchy cha = ClassHierarchy.make(scope);

		Iterable<Entrypoint> entrypoints = com.ibm.wala.ipa.callgraph.impl.Util.makeMainEntrypoints(scope, cha);
		AnalysisOptions options = new AnalysisOptions(scope, entrypoints);

		// build the call graph
		com.ibm.wala.ipa.callgraph.CallGraphBuilder cgb = Util.makeZeroCFABuilder(options, new AnalysisCache(),cha, scope, null, null);
//		CallGraph cg = cgb.makeCallGraph(options);
		CallGraph cg = cgb.makeCallGraph(options, null);
		PointerAnalysis pa = cgb.getPointerAnalysis();

		// find seed statement
		Statement statement = findCallTo(findMainMethod(cg), "println");

		Collection<Statement> slice;

		// context-sensitive traditional slice
		slice = Slicer.computeBackwardSlice ( statement, cg, pa );
		dumpSlice(slice);

		slice.stream()
			.mapToInt(s -> getLineNumber(s))
			.filter(line -> line != -1)
			.mapToObj(line -> "line = " + line)
			.forEach(System.out::println);
		
		// context-sensitive thin slice
		//          slice = Slicer.computeBackwardSlice(statement, cg, pa, DataDependenceOptions.NO_BASE_PTRS,
		//              ControlDependenceOptions.NONE);
		//          dumpSlice(slice);
		//
		//          // context-insensitive slice
		//          ThinSlicer ts = new ThinSlicer(cg,pa);
		//          Collection<Statement> slice = ts.computeBackwardThinSlice ( statement );
		//          dumpSlice(slice);
	}

	public static int getLineNumber(Statement s) {
		if (s.getKind() == Statement.Kind.NORMAL) { // ignore special kinds of statements
			int bcIndex, instructionIndex = ((NormalStatement) s).getInstructionIndex();
			try {
				bcIndex = ((ShrikeBTMethod) s.getNode().getMethod()).getBytecodeIndex(instructionIndex);
				try {
					int src_line_number = s.getNode().getMethod().getLineNumber(bcIndex);
					return src_line_number;
//					System.err.println ( "Source line number = " + src_line_number );
				} catch (Exception e) {
//					System.err.println("Bytecode index no good");
//					System.err.println(e.getMessage());
					return -1;
				}
			} catch (Exception e ) {
				return -1;
//				System.err.println("it's probably not a BT method (e.g. it's a fakeroot method)");
//				System.err.println(e.getMessage());
			}
		}
		return -1;
	}
	
	public static CGNode findMainMethod(CallGraph cg) {
		Descriptor d = Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V");
		Atom name = Atom.findOrCreateUnicodeAtom("main");
		for (Iterator<? extends CGNode> it = cg.getSuccNodes(cg.getFakeRootNode()); it.hasNext();) {
			CGNode n = it.next();
			if (n.getMethod().getName().equals(name) && n.getMethod().getDescriptor().equals(d)) {
				return n;
			}
		}
		Assertions.UNREACHABLE("failed to find main() method");
		return null;
	}

	public static Statement findCallTo(CGNode n, String methodName) {
		IR ir = n.getIR();
		for (Iterator<SSAInstruction> it = ir.iterateAllInstructions(); it.hasNext();) {
			SSAInstruction s = it.next();
			if (s instanceof com.ibm.wala.ssa.SSAAbstractInvokeInstruction) {
				com.ibm.wala.ssa.SSAAbstractInvokeInstruction call = (com.ibm.wala.ssa.SSAAbstractInvokeInstruction) s;
				if (call.getCallSite().getDeclaredTarget().getName().toString().equals(methodName)) {
					com.ibm.wala.util.intset.IntSet indices = ir.getCallInstructionIndices(call.getCallSite());
					com.ibm.wala.util.debug.Assertions.productionAssertion(indices.size() == 1, "expected 1 but got " + indices.size());
					return new com.ibm.wala.ipa.slicer.NormalStatement(n, indices.intIterator().next());
				}
			}
		}
		Assertions.UNREACHABLE("failed to find call to " + methodName + " in " + n);
		return null;
	}

	public static void dumpSlice(Collection<Statement> slice) {
		for (Statement s : slice) {
//			System.err.println(s);
			System.out.println(s);
		}
	}

}
