﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using System.IO;
using System.Text;

namespace Somali.XML
{
    class XIO
    {
        /// <summary>
        /// XML Document
        /// </summary>
        private XElement _XRoot = null;
        public XElement RootElement
        {
            set { this._XRoot = value; }
            get { return this._XRoot; }
        }

        /// <summary>
        /// ルート要素を持っているかどうかを示す値を取得します。
        /// </summary>
        /// <returns>True:存在する  / False:存在しない</returns>
        public bool HasRoot()
        {
            return (RootElement != null);
        }

        /// <summary>
        /// XMLファイルを読み込みます。
        /// </summary>
        /// <param name="filePath">読み込み元XMLファイルパス</param>
        public virtual void LoadXML( string filePath )
        {
            if ( string.IsNullOrEmpty( filePath ) == false )
            {
                RootElement = XElement.Load( filePath );
            }
            else
            {
                RootElement = null;
            }
        }

        /// <summary>
        /// XMLファイルを書き出します。
        /// </summary>
        /// <param name="filePath">保存先XMLファイルパス</param>
        public virtual void SaveXML( string filePath )
        {
            if ( RootElement != null )
            {
                RootElement.Save( filePath );
            }
        }

        /// <summary>
        /// ルート要素の持つ1つ以上の要素を取得します。
        /// </summary>
        /// <returns>ルート要素のXMLツリー下の要素を返却します。
        /// 要素を持たない場合はnullを返却します。</returns>
        public IEnumerable<XElement> GetAllElements()
        {
            return GetAllElements( RootElement );
        }

        /// <summary>
        /// 指定されたXElementの持つ1つ以上の要素を取得します。
        /// </summary>
        /// <param name="element">XElement</param>
        /// <returns>指定されたXElementのXMLツリー下の要素を返却します。
        /// 要素を持たない場合はnullを返却します。</returns>
        public IEnumerable<XElement> GetAllElements( XElement element )
        {
            if ( element.HasElements == true )
            {
                return element.Elements();
            }
            else
            {
                return null;
            }
        }

        public virtual string GetElementByTag( string tag )
        {
            IEnumerable<XElement> query = RootElement.Descendants( tag );
            if ( query.ToList().Count == 1 )
            {
                return query.ToString();
            }
            else
            {
                return string.Empty;
            }
        }
    }
}
