﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using System.Text;
using System.Windows.Forms;

using Somali.XML;

namespace XMLEditorMini
{
    class XMLToTreeView : XIO
    {
        private XDocument _XDoc = null;
        public XDocument XMLFile
        {
            set { this._XDoc = value; }
            get { return this._XDoc; }
        }

        public override void LoadXML( string filePath )
        {
            XMLFile = XDocument.Load( filePath );
            base.RootElement = XMLFile.Root;
        }

        /// <summary>
        /// XMLドキュメントをTreeNodeに展開します。
        /// </summary>
        public TreeNode SetXmlToTreeView()
        {
            if ( this.XMLFile != null )
            {
                TreeNode rootNode = new TreeNode( "<" + XMLFile.Root.Name.LocalName + ">" );
                GetNode( rootNode, XMLFile.Root );
                return rootNode;
            }
            else
            {
                return null;
            }
        }

        public TreeNode SetXmlToTreeView( string filePath )
        {
            this.LoadXML( filePath );
            return SetXmlToTreeView();
        }

        private void GetNode( TreeNode root, XElement nodeElement )
        {
            TreeNode tempNode;
            IEnumerable<XElement> node = GetAllElements( nodeElement );
            foreach ( XElement xe in node )
            {
                if ( xe.HasElements == true )
                {
                    tempNode = new TreeNode( "<" + xe.Name.LocalName + ">" );
                    GetNode( tempNode, xe );
                    root.Nodes.Add( tempNode );
                }
                else
                {
                    tempNode = new TreeNode( "<" + xe.Name.LocalName + ">" );
                    tempNode.Nodes.Add( new TreeNode( xe.Value ) );
                    root.Nodes.Add( tempNode );
                }
            }
        }

    }
}
