﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using Somali.Base;
using Somali.Models;

namespace Somali.EnvControl
{
    partial class CentralMediator : IActionMediator, IDisposable
    {
        private Dictionary<SomaliAction, Action<SomaliActionArgs>> _actionMap;

        private PreferencesSecretary prefSec;
        private LayoutSecretary layoutSec;
        private ResourceSecretary resSec;
        private DockPanel _mainDockPanel;

        private SomaliForm _mainForm;
        /// <summary>
        /// 実行フォーム
        /// </summary>
        public Form RunForm
        {
            get { return this._mainForm; }
        }

        public CentralMediator()
        {
            this._mainForm = new SomaliForm();
            this._mainDockPanel = this._mainForm.MainDockPanel;

            prefSec = new PreferencesSecretary();
            layoutSec = new LayoutSecretary( this._mainForm, this._mainDockPanel );
            resSec = new ResourceSecretary();

            InitializeActionMap();

            InitializeColleagues();
        }

        ~CentralMediator()
        {
            Dispose();
        }

        public void Dispose()
        {
        }

        private void InitializeActionMap()
        {
            this._actionMap = new Dictionary<SomaliAction, Action<SomaliActionArgs>>();
            this._actionMap.Add( SomaliAction.Exit, ExitApplication );
            this._actionMap.Add( SomaliAction.OpenDir, OpenDirectory );
            this._actionMap.Add( SomaliAction.ShowExplorer, ShowExplorer );
            this._actionMap.Add( SomaliAction.ShowOutlineAnalizer, ShowOutline );
            this._actionMap.Add( SomaliAction.ExpandExplorerNode, ExpandExplorerNode );
        }

        private void InitializeColleagues()
        {
            // 設定情報読み込み
            prefSec.InitPreferences();

            // Layout復元
            layoutSec.InitializeLayout();

            this._mainForm.SetMediator( this );
        }

        /// <summary>
        /// ユーザアクションによる処理振り分け
        /// </summary>
        /// <param name="e"></param>
        public void DispatchAction( SomaliActionArgs e )
        {
            Action<SomaliActionArgs> doAction;
            if ( this._actionMap.TryGetValue( e.ActionID, out doAction ) )
            {
                // カーソルを待機状態に
                Cursor.Current = Cursors.WaitCursor;

                doAction( e );

                // カーソルをデフォルトに戻す
                Cursor.Current = Cursors.Default;
            }
        }

        private void ShowColleague<T>( Model model )
            where T : DockContent, IDockContent, IActionColleague, new()
        {
            T colleague;
            if ( layoutSec.GetDockFormImpl( out colleague ) )
            {
                colleague.SetMediator( this );
                colleague.Bind( model );
                DockState ds = (colleague.DockState != DockState.Unknown && colleague.DockState != DockState.Hidden)
                                    ? colleague.DockState : colleague.DefaultDockState;
                colleague.Show( this._mainDockPanel, ds );
            }
        }


    }
}
