using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using WeifenLuo.WinFormsUI.Docking;
using Somali.EnvControl;
using Somali.Base;

namespace Somali
{
    public partial class SomaliForm : SomaliBaseForm, IWindowPreservable, IActionColleague
    {
        private IActionMediator _mediator;
        public void SetMediator( IActionMediator mediator )
        {
            this._mediator = mediator;
        }

        #region vpeB
        private Size _normalizeSize;
        /// <summary>
        /// WTCY
        /// </summary>
        public Size NormalizeSize
        {
            set { this._normalizeSize = value; }
            get { return this._normalizeSize; }
        }

        private Point _normalizeLocation;
        /// <summary>
        /// WP[V
        /// </summary>
        public Point NormalizeLocation
        {
            set { this._normalizeLocation = value; }
            get { return this._normalizeLocation; }
        }

        /// <summary>
        /// DockPanelR|[lg
        /// </summary>
        public DockPanel MainDockPanel
        {
            get { return this.dockPanelMain; }
        }

        public DockState DefaultDockState
        {
            get { return DockState.Unknown; }
        }
        #endregion

        public SomaliForm()
        {
            InitializeComponent();
            //this.SetStyle( ControlStyles.CacheText, true );
            //this.SetStyle( ControlStyles.OptimizedDoubleBuffer, true );
            //this.SetStyle( ControlStyles.AllPaintingInWmPaint, true );
        }

        /// <summary>
        /// DockPanel̑݌
        /// </summary>
        /// <param name="dockPanel"></param>
        /// <returns>true:݂<br/>false:݂Ȃ</returns>
        public bool IsContainDockPanel( DockPanel dockPanel )
        {
            return this.Controls.Contains( dockPanel );
        }

        public void Reflesh() { }
        public void Bind( Model model ) { }
        public void Initialize() { }

        #region formEvent
        private void SomaliForm_FormClosing( object sender, FormClosingEventArgs e )
        {
            this._mediator.DispatchAction( new SomaliActionArgs( SomaliAction.Exit ) );
        }

        private void SomaliForm_WindowStateChanging( object sender, WindowStateChangingEventArgs e )
        {
            if ( this.WindowState == FormWindowState.Normal && e.WindowState != FormWindowState.Normal )
            {
                this.NormalizeSize = this.Size;
                this.NormalizeLocation = this.Location;
            }
        }
        #endregion

        #region file
        private void openDirMenuItem_Click( object sender, EventArgs e )
        {
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.Description = "fBNgIĉB";
            fbd.RootFolder = Environment.SpecialFolder.Desktop;
            fbd.ShowNewFolderButton = false;
            if ( fbd.ShowDialog() == DialogResult.OK )
            {
                this._mediator.DispatchAction( new SomaliActionArgs( SomaliAction.OpenDir, fbd.SelectedPath ) );
            }
        }

        private void exitMenuItem_Click( object sender, EventArgs e )
        {
            //Application.Exit();
            this.Close();
        }
        #endregion

        #region view
        private void explorerMenuItem_Click( object sender, EventArgs e )
        {
            this._mediator.DispatchAction( new SomaliActionArgs( SomaliAction.ShowExplorer ) );
        }

        #endregion

        #region analyze
        private void outlineMenuItem_Click( object sender, EventArgs e )
        {
            this._mediator.DispatchAction( new SomaliActionArgs( SomaliAction.ShowOutlineAnalizer ) );
        }
        #endregion

        #region tools
        private void preferencesMenuItem_Click( object sender, EventArgs e )
        {
            PreferencesForm frmPreferences = new PreferencesForm();
            frmPreferences.ShowDialog();
        }
        #endregion

        #region help
        private void aboutMenuItem_Click( object sender, EventArgs e )
        {
            AboutBox frmAbout = new AboutBox();
            frmAbout.ShowDialog();
        }
        #endregion

    }
}