package SWCmdRSS;

#----------------------------------------
# RSSo
#----------------------------------------
sub CmdRSS {
	my $sow = $_[0];
	my $query = $sow->{'query'};
	my $cfg   = $sow->{'cfg'};

	require "$cfg->{'DIR_HTML'}/html.pl";
	if (defined($query->{'vid'})) {
		&OutRSSVLog($sow);
	} else {
		&OutRSSVIndex($sow);
	}
}

#----------------------------------------
# ꗗRSSo
#----------------------------------------
sub OutRSSVIndex {
	my $sow = $_[0];
	my $query = $sow->{'query'};
	my $cfg   = $sow->{'cfg'};
	my $urlsow = "$cfg->{'URL_SW'}/$cfg->{'FILE_SOW'}";
	my @items = (
	);

	require "$cfg->{'DIR_LIB'}/file_vindex.pl";
	my $vindex = SWFileVIndex->new($sow);
	$vindex->openvindex();
	$vindex->closevindex();

	my $vilist = $vindex->getvilist();
	foreach (@$vilist) {
		next if ($_->{'vstatus'} != $sow->{'VSTATUSID_PRO'});
		my %item = (
			title   => "$_->{'vid'} $_->{'vname'}",
			name    => $_->{'makeruid'},
			date    => $_->{'createdt'},
			link    => "$urlsow?vid=$_->{'vid'}",
			content => $_->{'vcomment'},
		);
		unshift(@items, \%item);
	}

	# XV
#	$sow->{'http'}->{'lastmodified'} = $vindex->getupdatedt();
#	$sow->{'http'}->setnotmodified();

	if ($query->{'cmd'} eq 'rss') {
		require "$cfg->{'DIR_LIB'}/rss.pl";
		&SWRSS::OutXMLRSS($sow, 'W^JnȎ̈ꗗ', 'VK쐬ꂽ̂A܂W܂͊JnȎ̈ꗗłB', $urlsow, \@items);
	} else {
		require "$cfg->{'DIR_LIB'}/summary.pl";
		&SWSummary::OutSWSummary($sow, 'W^JnȎ̈ꗗ', 'VK쐬ꂽ̂A܂W܂͊JnȎ̈ꗗłB', $urlsow, \@items);
	}

	return;
}

#----------------------------------------
# ORSSo
#----------------------------------------
sub OutRSSVLog {
	my $sow = $_[0];
	my $query = $sow->{'query'};
	my $cfg   = $sow->{'cfg'};
	my $urlsow = "$cfg->{'URL_SW'}/$cfg->{'FILE_SOW'}";
	my @items = (
	);

	# f[^̓ǂݍ
	require "$cfg->{'DIR_LIB'}/file_vil.pl";
	my $vil = SWFileVil->new($sow, $sow->{'query'}->{'vid'});
	$vil->readvil();

	# \[X̓ǂݍ
	&SWBase::LoadVilRS($sow, $vil);

	require "$sow->{'cfg'}->{'DIR_LIB'}/log.pl";
	require "$sow->{'cfg'}->{'DIR_LIB'}/file_log.pl";
	require "$sow->{'cfg'}->{'DIR_LIB'}/file_memo.pl";
	my $maxrow = $sow->{'cfg'}->{'MAX_ROW'};
	$maxrow = $query->{'row'} if (defined($query->{'row'}) && ($query->{'row'} ne ''));
	$maxrow = -1 if (($maxrow eq 'all') || ($query->{'rowall'} ne ''));

	# O̎擾
	my $logs;
	my $turn = $sow->{'turn'};
	$turn-- if (($sow->{'turn'} == $vil->{'turn'}) && ($vil->{'epilogue'} < $vil->{'turn'}));
	my $loop = 1;
	while ($loop > 0) {
		$loop = 0;

		my $logfile = SWBoa->new($sow, $vil, $turn, 0);
		my $memofile = SWSnake->new($sow, $vil, $turn, 0);
		my $memoindex = $memofile->{'memoindex'}->{'file'};
		my ($logidx, $rows) = $logfile->getvlogs($maxrow);
		my @logsday;
		my $i;
		for ($i = $#$logidx; $i >= 0; $i--) {
			my $log = $logfile->{'logfile'}->{'file'}->read($logidx->[$i]->{'pos'});
			$log->{'logtype'} = 'log';
			if ($log->{'memoid'} ne $sow->{'DATATEXT_NONE'}) {
				my $indexno = $memoindex->getbyid($log->{'memoid'});
				$log = $memofile->read($memoindex->getlist->[$indexno]->{'pos'});
				$log->{'logtype'} = 'memo';
				$log->{'logsubid'} = $sow->{'LOGSUBID_UNDEF'};
			} else {
				$log->{'logid'} = $log->{'maskedid'} if ((($log->{'mestype'} == $sow->{'MESTYPE_INFOSP'}) || ($log->{'mestype'} == $sow->{'MESTYPE_TSAY'})) && ($vil->isepilogue() == 0));
			}
			$log->{'turn'} = $turn;
			unshift(@$logs, $log);

			last if (@$logs >= $maxrow);
		}
		if ((@$logs < $maxrow) && ($turn > 0)) {
			$turn--;
			$loop = 1;
		}
		$logfile->close();
	}

	my $i;
	for ($i = $#$logs; $i >= 0; $i--) {
		my $chrname;
		my $log = $logs->[$i];
		if ($log->{'cid'} eq $sow->{'DATATEXT_NONE'}) {
			$chrname = '[]';
		} else {
			$chrname = $log->{'chrname'};
			$chrname = "[] $chrname" if ($log->{'logtype'} eq 'memo');
		}
		my $turn = '';
		$turn = "&amp;turn=$log->{'turn'}" if ($log->{'turn'} != $sow->{'turn'});
		my $content = $log->{'log'};
		$content = "$chrnaméA$content" if ($log->{'logsubid'} eq $sow->{'LOGSUBID_ACTION'});
		$content = &SWLog::ReplaceAnchorHTMLRSS($sow, $vil, $content);
		my $cmd = '';
		$cmd = "&amp;cmd=hist" if ($log->{'logtype'} eq 'memo');
		my %item = (
			title   => $chrname,
			name    => $chrname,
			date    => $log->{'date'},
			link    => "$urlsow?vid=$vil->{'vid'}$turn&amp;logid=$log->{'logid'}$cmd",
			content => $content,
		);
		unshift(@items, \%item);
	}

	require "$cfg->{'DIR_LIB'}/rss.pl";
	&SWRSS::OutXMLRSS($sow, "$vil->{'vid'} $vil->{'vname'}", "$vil->{'vid'} $vil->{'vname'} ̔łB", $urlsow, \@items);
	return;

}

1;