unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms3D, FMX.Types3D, FMX.Forms, FMX.Graphics,
  FMX.Dialogs, System.Math.Vectors, FMX.Controls3D, FMX.Objects3D,
  FMX.MaterialSources,
  Generics.Collections;

type
  TForm1 = class(TForm3D)
    Disk1: TDisk;
    Timer1: TTimer;
    LightMaterialSource1: TLightMaterialSource;
    Light1: TLight;
    Light2: TLight;
    Plane1: TPlane;
    Camera1: TCamera;
    procedure Timer1Timer(Sender: TObject);
    procedure Form3DCreate(Sender: TObject);
    procedure Form3DDestroy(Sender: TObject);
    procedure Form3DKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
  private
    { private 錾 }
  public
    { public 錾 }
    radian: Single;
    a: Single;
    List: TList<TPosition3D>;
    DList: TList;
    count: integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

const
  r: Single = 3;
  speed: Single = 0.08;
  ax: Single = 0;
  ay: Single = 1;
  c = 5;

procedure TForm1.Form3DCreate(Sender: TObject);
begin
  Disk1.Position.X := ax;
  radian := Pi * 3 / 2;
  a := speed / r;
  List := TList<TPosition3D>.Create;
  DList := TList.Create;
  count := c;
end;

procedure TForm1.Form3DDestroy(Sender: TObject);
begin
  Timer1.Enabled := false;
  List.Free;
  DList.Free;
end;

procedure TForm1.Form3DKeyDown(Sender: TObject; var Key: Word;
  var KeyChar: Char; Shift: TShiftState);
begin
  Close;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  i, j: integer;
  s: TDisk;
begin
  List.Add(TPosition3D.Create(TPoint3D.Create(Disk1.Position.X,
    Disk1.Position.Y, 0)));
  if count > 0 then
    dec(count);
  for i := 0 to DList.count - 1 do
  begin
    s := DList[i];
    j := List.count - (i + 1) * c;
    if j >= 0 then
      s.Position.Assign(List[j]);
    if s.Visible = false then
      s.Visible := true;
  end;
  if Disk1.Position.Y < ay - r then
  begin
    Disk1.Position.Y := Disk1.Position.Y + speed;
    if count = 0 then
    begin
      s := TDisk.Create(Self);
      s.MaterialSource := LightMaterialSource1;
      s.RotationAngle.Assign(Disk1.RotationAngle);
      s.Visible := false;
      s.Parent := Self;
      DList.Add(s);
      count := c;
    end;
  end
  else
  begin
    List.Delete(0);
    if radian < 0 then
      radian := radian + 2 * Pi;
    Disk1.Position.X := ax + r * cos(radian);
    Disk1.Position.Y := ay + r * sin(radian);
    radian := radian + a;
  end;
end;

end.
