/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGOMCSSImportedElementRoot;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGUseElementBridge
extends AbstractGraphicsNodeBridge {
    protected ReferencedElementMutationListener l;
    protected BridgeContext subCtx = null;

    public String getLocalName() {
        return "use";
    }

    public Bridge getInstance() {
        return new SVGUseElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        if (!SVGUtilities.matchUserAgent(e, ctx.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode gn = this.buildCompositeGraphicsNode(ctx, e, null);
        return gn;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext ctx, Element e, CompositeGraphicsNode gn) {
        EventTarget target;
        Rectangle2D r;
        Element localRefElement;
        String uri = XLinkSupport.getXLinkHref((Element)e);
        if (uri.length() == 0) {
            throw new BridgeException(e, "attribute.missing", new Object[]{"xlink:href"});
        }
        Element refElement = ctx.getReferencedElement(e, uri);
        SVGOMDocument document = (SVGOMDocument)e.getOwnerDocument();
        SVGOMDocument refDocument = (SVGOMDocument)refElement.getOwnerDocument();
        boolean isLocal = refDocument == document;
        BridgeContext theCtx = ctx;
        this.subCtx = null;
        if (!isLocal) {
            CSSEngine eng = refDocument.getCSSEngine();
            theCtx = this.subCtx = (BridgeContext)refDocument.getCSSEngine().getCSSContext();
        }
        if ("symbol".equals((localRefElement = (Element)document.importNode((Node)refElement, true, true)).getLocalName())) {
            Element svgElement = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            NamedNodeMap attrs = localRefElement.getAttributes();
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attrs.item(i);
                svgElement.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
            }
            Node n = localRefElement.getFirstChild();
            while (n != null) {
                svgElement.appendChild(n);
                n = localRefElement.getFirstChild();
            }
            localRefElement = svgElement;
        }
        if ("svg".equals(localRefElement.getLocalName())) {
            String hStr;
            String wStr = e.getAttributeNS(null, "width");
            if (wStr.length() != 0) {
                localRefElement.setAttributeNS(null, "width", wStr);
            }
            if ((hStr = e.getAttributeNS(null, "height")).length() != 0) {
                localRefElement.setAttributeNS(null, "height", hStr);
            }
        }
        SVGOMCSSImportedElementRoot root = new SVGOMCSSImportedElementRoot((AbstractDocument)document, e, isLocal);
        root.appendChild((Node)localRefElement);
        if (gn == null) {
            gn = new CompositeGraphicsNode();
        } else {
            int s = gn.size();
            for (int i = 0; i < s; ++i) {
                gn.remove(0);
            }
        }
        SVGOMUseElement ue = (SVGOMUseElement)e;
        CSSImportedElementRoot oldRoot = ue.getCSSImportedElementRoot();
        if (oldRoot != null) {
            SVGUseElementBridge.disposeTree((Node)oldRoot);
        }
        ue.setCSSImportedElementRoot((CSSImportedElementRoot)root);
        Element g = localRefElement;
        CSSUtilities.computeStyleAndURIs(refElement, localRefElement, uri);
        GVTBuilder builder = ctx.getGVTBuilder();
        GraphicsNode refNode = builder.build(ctx, g);
        gn.getChildren().add(refNode);
        gn.setTransform(this.computeTransform(e, ctx));
        gn.setVisible(CSSUtilities.convertVisibility(e));
        RenderingHints hints = null;
        hints = CSSUtilities.convertColorRendering(e, hints);
        if (hints != null) {
            gn.setRenderingHints(hints);
        }
        if ((r = CSSUtilities.convertEnableBackground(e)) != null) {
            gn.setBackgroundEnable(r);
        }
        if (this.l != null) {
            target = this.l.target;
            target.removeEventListener("DOMAttrModified", this.l, true);
            target.removeEventListener("DOMNodeInserted", this.l, true);
            target.removeEventListener("DOMNodeRemoved", this.l, true);
            target.removeEventListener("DOMCharacterDataModified", this.l, true);
            this.l = null;
        }
        if (isLocal && ctx.isDynamic()) {
            this.l = new ReferencedElementMutationListener();
            this.l.target = target = (EventTarget)((Object)refElement);
            target.addEventListener("DOMAttrModified", this.l, true);
            theCtx.storeEventListener(target, "DOMAttrModified", this.l, true);
            target.addEventListener("DOMNodeInserted", this.l, true);
            theCtx.storeEventListener(target, "DOMNodeInserted", this.l, true);
            target.addEventListener("DOMNodeRemoved", this.l, true);
            theCtx.storeEventListener(target, "DOMNodeRemoved", this.l, true);
            target.addEventListener("DOMCharacterDataModified", this.l, true);
            theCtx.storeEventListener(target, "DOMCharacterDataModified", this.l, true);
        }
        return gn;
    }

    public void dispose() {
        SVGOMUseElement ue;
        if (this.l != null) {
            EventTarget target = this.l.target;
            target.removeEventListener("DOMAttrModified", this.l, true);
            target.removeEventListener("DOMNodeInserted", this.l, true);
            target.removeEventListener("DOMNodeRemoved", this.l, true);
            target.removeEventListener("DOMCharacterDataModified", this.l, true);
            this.l = null;
        }
        if ((ue = (SVGOMUseElement)this.e) != null && ue.getCSSImportedElementRoot() != null) {
            SVGUseElementBridge.disposeTree((Node)ue.getCSSImportedElementRoot());
        }
        super.dispose();
        this.subCtx = null;
    }

    protected AffineTransform computeTransform(Element e, BridgeContext ctx) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        float x = 0.0f;
        String s = e.getAttributeNS(null, "x");
        if (s.length() != 0) {
            x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
        }
        float y = 0.0f;
        s = e.getAttributeNS(null, "y");
        if (s.length() != 0) {
            y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
        }
        s = e.getAttributeNS(null, "transform");
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        if (s.length() != 0) {
            at.preConcatenate(SVGUtilities.convertTransform(e, "transform", s));
        }
        return at;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        super.buildGraphicsNode(ctx, e, node);
        if (ctx.isInteractive()) {
            EventTarget target = (EventTarget)((Object)e);
            CursorMouseOverListener l = new CursorMouseOverListener(ctx);
            target.addEventListener("mouseover", l, false);
            ctx.storeEventListener(target, "mouseover", l, false);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        Node evtNode = evt.getRelatedNode();
        if (evtNode.getNamespaceURI() == null && (attrName.equals("x") || attrName.equals("y") || attrName.equals("transform"))) {
            this.node.setTransform(this.computeTransform(this.e, this.ctx));
            this.handleGeometryChanged();
        } else if (evtNode.getNamespaceURI() == null && (attrName.equals("width") || attrName.equals("height")) || "http://www.w3.org/1999/xlink".equals(evtNode.getNamespaceURI()) && "href".equals(evtNode.getLocalName())) {
            this.buildCompositeGraphicsNode(this.ctx, this.e, (CompositeGraphicsNode)this.node);
        }
    }

    public class ReferencedElementMutationListener
    implements EventListener {
        EventTarget target;

        public void handleEvent(Event evt) {
            SVGUseElementBridge.this.buildCompositeGraphicsNode(SVGUseElementBridge.this.ctx, SVGUseElementBridge.this.e, (CompositeGraphicsNode)SVGUseElementBridge.this.node);
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected BridgeContext ctx;

        public CursorMouseOverListener(BridgeContext ctx) {
            this.ctx = ctx;
        }

        public void handleEvent(Event evt) {
            Cursor cursor;
            Element currentTarget = (Element)((Object)evt.getCurrentTarget());
            if (!CSSUtilities.isAutoCursor(currentTarget) && (cursor = CSSUtilities.convertCursor(currentTarget, this.ctx)) != null) {
                this.ctx.getUserAgent().setSVGCursor(cursor);
            }
        }
    }
}

