/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;

public final class Rect {
    public final double xmin;
    public final double ymin;
    public final double xmax;
    public final double ymax;
    public static final Rect emptyRect = new Rect(0.0, 0.0, 0.0, 0.0);

    public Rect(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.ymin = d2;
        this.xmax = d3;
        this.ymax = d4;
    }

    public Rect(double[] dArray) {
        this.xmin = dArray[0];
        this.ymin = dArray[1];
        this.xmax = dArray[2];
        this.ymax = dArray[3];
    }

    public Rect applyMatrix(Matrix matrix) {
        if (matrix.isIdentity()) {
            return this;
        }
        double d = matrix.applyToXYGetX(this.xmin, this.ymax);
        double d2 = matrix.applyToXYGetY(this.xmin, this.ymax);
        double d3 = matrix.applyToXYGetX(this.xmax, this.ymax);
        double d4 = matrix.applyToXYGetY(this.xmax, this.ymax);
        double d5 = matrix.applyToXYGetX(this.xmax, this.ymin);
        double d6 = matrix.applyToXYGetY(this.xmax, this.ymin);
        double d7 = matrix.applyToXYGetX(this.xmin, this.ymin);
        double d8 = matrix.applyToXYGetY(this.xmin, this.ymin);
        return new Rect(Math.min(Math.min(d, d3), Math.min(d5, d7)), Math.min(Math.min(d2, d4), Math.min(d6, d8)), Math.max(Math.max(d, d3), Math.max(d5, d7)), Math.max(Math.max(d2, d4), Math.max(d6, d8)));
    }

    public Rect toEmSpace(double d, double d2) {
        return new Rect(this.xmin / d, this.ymin / d2, this.xmax / d, this.ymax / d2);
    }

    public Rect toDesignSpace(double d, double d2) {
        return new Rect(this.xmin * d, this.ymin * d2, this.xmax * d, this.ymax * d2);
    }

    public String toString() {
        return "[ " + Double.toString(this.xmin) + " " + Double.toString(this.ymin) + " " + Double.toString(this.xmax) + " " + Double.toString(this.ymax) + " ]";
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (this == object) {
                return true;
            }
            if (object instanceof Rect) {
                Rect rect = (Rect)object;
                return Double.compare(this.xmin, rect.xmin) == 0 && Double.compare(this.ymin, rect.ymin) == 0 && Double.compare(this.xmax, rect.xmax) == 0 && Double.compare(this.ymax, rect.ymax) == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)this.xmin ^ (int)this.xmax ^ (int)this.ymin ^ (int)this.ymax;
    }
}

